package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamsTotalCount invokes the live.DescribeLiveStreamsTotalCount API synchronously
func (client *Client) DescribeLiveStreamsTotalCount(request *DescribeLiveStreamsTotalCountRequest) (response *DescribeLiveStreamsTotalCountResponse, err error) {
	response = CreateDescribeLiveStreamsTotalCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamsTotalCountWithChan invokes the live.DescribeLiveStreamsTotalCount API asynchronously
func (client *Client) DescribeLiveStreamsTotalCountWithChan(request *DescribeLiveStreamsTotalCountRequest) (<-chan *DescribeLiveStreamsTotalCountResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamsTotalCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamsTotalCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamsTotalCountWithCallback invokes the live.DescribeLiveStreamsTotalCount API asynchronously
func (client *Client) DescribeLiveStreamsTotalCountWithCallback(request *DescribeLiveStreamsTotalCountRequest, callback func(response *DescribeLiveStreamsTotalCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamsTotalCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamsTotalCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamsTotalCountRequest is the request struct for api DescribeLiveStreamsTotalCount
type DescribeLiveStreamsTotalCountRequest struct {
	*requests.RpcRequest
	Typ        string           `position:"Query" name:"Typ"`
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamsTotalCountResponse is the response struct for api DescribeLiveStreamsTotalCount
type DescribeLiveStreamsTotalCountResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	StreamCountList StreamCountList `json:"StreamCountList" xml:"StreamCountList"`
}

// CreateDescribeLiveStreamsTotalCountRequest creates a request to invoke DescribeLiveStreamsTotalCount API
func CreateDescribeLiveStreamsTotalCountRequest() (request *DescribeLiveStreamsTotalCountRequest) {
	request = &DescribeLiveStreamsTotalCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamsTotalCount", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamsTotalCountResponse creates a response to parse from DescribeLiveStreamsTotalCount response
func CreateDescribeLiveStreamsTotalCountResponse() (response *DescribeLiveStreamsTotalCountResponse) {
	response = &DescribeLiveStreamsTotalCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
