package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRtcAsrTask invokes the live.DeleteRtcAsrTask API synchronously
func (client *Client) DeleteRtcAsrTask(request *DeleteRtcAsrTaskRequest) (response *DeleteRtcAsrTaskResponse, err error) {
	response = CreateDeleteRtcAsrTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRtcAsrTaskWithChan invokes the live.DeleteRtcAsrTask API asynchronously
func (client *Client) DeleteRtcAsrTaskWithChan(request *DeleteRtcAsrTaskRequest) (<-chan *DeleteRtcAsrTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteRtcAsrTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRtcAsrTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRtcAsrTaskWithCallback invokes the live.DeleteRtcAsrTask API asynchronously
func (client *Client) DeleteRtcAsrTaskWithCallback(request *DeleteRtcAsrTaskRequest, callback func(response *DeleteRtcAsrTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRtcAsrTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteRtcAsrTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRtcAsrTaskRequest is the request struct for api DeleteRtcAsrTask
type DeleteRtcAsrTaskRequest struct {
	*requests.RpcRequest
	TaskId  string           `position:"Query" name:"TaskId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteRtcAsrTaskResponse is the response struct for api DeleteRtcAsrTask
type DeleteRtcAsrTaskResponse struct {
	*responses.BaseResponse
	Description string `json:"Description" xml:"Description"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RetCode     int64  `json:"RetCode" xml:"RetCode"`
}

// CreateDeleteRtcAsrTaskRequest creates a request to invoke DeleteRtcAsrTask API
func CreateDeleteRtcAsrTaskRequest() (request *DeleteRtcAsrTaskRequest) {
	request = &DeleteRtcAsrTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteRtcAsrTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRtcAsrTaskResponse creates a response to parse from DeleteRtcAsrTask response
func CreateDeleteRtcAsrTaskResponse() (response *DeleteRtcAsrTaskResponse) {
	response = &DeleteRtcAsrTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
