package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRecordDownloadByTimeJob invokes the linkvisual.CreateRecordDownloadByTimeJob API synchronously
func (client *Client) CreateRecordDownloadByTimeJob(request *CreateRecordDownloadByTimeJobRequest) (response *CreateRecordDownloadByTimeJobResponse, err error) {
	response = CreateCreateRecordDownloadByTimeJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRecordDownloadByTimeJobWithChan invokes the linkvisual.CreateRecordDownloadByTimeJob API asynchronously
func (client *Client) CreateRecordDownloadByTimeJobWithChan(request *CreateRecordDownloadByTimeJobRequest) (<-chan *CreateRecordDownloadByTimeJobResponse, <-chan error) {
	responseChan := make(chan *CreateRecordDownloadByTimeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRecordDownloadByTimeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRecordDownloadByTimeJobWithCallback invokes the linkvisual.CreateRecordDownloadByTimeJob API asynchronously
func (client *Client) CreateRecordDownloadByTimeJobWithCallback(request *CreateRecordDownloadByTimeJobRequest, callback func(response *CreateRecordDownloadByTimeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRecordDownloadByTimeJobResponse
		var err error
		defer close(result)
		response, err = client.CreateRecordDownloadByTimeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRecordDownloadByTimeJobRequest is the request struct for api CreateRecordDownloadByTimeJob
type CreateRecordDownloadByTimeJobRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	RecordType    requests.Integer `position:"Query" name:"RecordType"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	BeginTime     requests.Integer `position:"Query" name:"BeginTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// CreateRecordDownloadByTimeJobResponse is the response struct for api CreateRecordDownloadByTimeJob
type CreateRecordDownloadByTimeJobResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCreateRecordDownloadByTimeJobRequest creates a request to invoke CreateRecordDownloadByTimeJob API
func CreateCreateRecordDownloadByTimeJobRequest() (request *CreateRecordDownloadByTimeJobRequest) {
	request = &CreateRecordDownloadByTimeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "CreateRecordDownloadByTimeJob", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRecordDownloadByTimeJobResponse creates a response to parse from CreateRecordDownloadByTimeJob response
func CreateCreateRecordDownloadByTimeJobResponse() (response *CreateRecordDownloadByTimeJobResponse) {
	response = &CreateRecordDownloadByTimeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
