package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApplicationAccessPoint invokes the kms.DeleteApplicationAccessPoint API synchronously
func (client *Client) DeleteApplicationAccessPoint(request *DeleteApplicationAccessPointRequest) (response *DeleteApplicationAccessPointResponse, err error) {
	response = CreateDeleteApplicationAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApplicationAccessPointWithChan invokes the kms.DeleteApplicationAccessPoint API asynchronously
func (client *Client) DeleteApplicationAccessPointWithChan(request *DeleteApplicationAccessPointRequest) (<-chan *DeleteApplicationAccessPointResponse, <-chan error) {
	responseChan := make(chan *DeleteApplicationAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApplicationAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApplicationAccessPointWithCallback invokes the kms.DeleteApplicationAccessPoint API asynchronously
func (client *Client) DeleteApplicationAccessPointWithCallback(request *DeleteApplicationAccessPointRequest, callback func(response *DeleteApplicationAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApplicationAccessPointResponse
		var err error
		defer close(result)
		response, err = client.DeleteApplicationAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApplicationAccessPointRequest is the request struct for api DeleteApplicationAccessPoint
type DeleteApplicationAccessPointRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// DeleteApplicationAccessPointResponse is the response struct for api DeleteApplicationAccessPoint
type DeleteApplicationAccessPointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteApplicationAccessPointRequest creates a request to invoke DeleteApplicationAccessPoint API
func CreateDeleteApplicationAccessPointRequest() (request *DeleteApplicationAccessPointRequest) {
	request = &DeleteApplicationAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "DeleteApplicationAccessPoint", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteApplicationAccessPointResponse creates a response to parse from DeleteApplicationAccessPoint response
func CreateDeleteApplicationAccessPointResponse() (response *DeleteApplicationAccessPointResponse) {
	response = &DeleteApplicationAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
