package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTopicConfig invokes the iot.QueryTopicConfig API synchronously
func (client *Client) QueryTopicConfig(request *QueryTopicConfigRequest) (response *QueryTopicConfigResponse, err error) {
	response = CreateQueryTopicConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTopicConfigWithChan invokes the iot.QueryTopicConfig API asynchronously
func (client *Client) QueryTopicConfigWithChan(request *QueryTopicConfigRequest) (<-chan *QueryTopicConfigResponse, <-chan error) {
	responseChan := make(chan *QueryTopicConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTopicConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTopicConfigWithCallback invokes the iot.QueryTopicConfig API asynchronously
func (client *Client) QueryTopicConfigWithCallback(request *QueryTopicConfigRequest, callback func(response *QueryTopicConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTopicConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryTopicConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTopicConfigRequest is the request struct for api QueryTopicConfig
type QueryTopicConfigRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QueryTopicConfigResponse is the response struct for api QueryTopicConfig
type QueryTopicConfigResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   bool                   `json:"Success" xml:"Success"`
	Code      string                 `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      DataInQueryTopicConfig `json:"Data" xml:"Data"`
}

// CreateQueryTopicConfigRequest creates a request to invoke QueryTopicConfig API
func CreateQueryTopicConfigRequest() (request *QueryTopicConfigRequest) {
	request = &QueryTopicConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryTopicConfig", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTopicConfigResponse creates a response to parse from QueryTopicConfig response
func CreateQueryTopicConfigResponse() (response *QueryTopicConfigResponse) {
	response = &QueryTopicConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
