package grace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadFileByOSS invokes the grace.UploadFileByOSS API synchronously
func (client *Client) UploadFileByOSS(request *UploadFileByOSSRequest) (response *UploadFileByOSSResponse, err error) {
	response = CreateUploadFileByOSSResponse()
	err = client.DoAction(request, response)
	return
}

// UploadFileByOSSWithChan invokes the grace.UploadFileByOSS API asynchronously
func (client *Client) UploadFileByOSSWithChan(request *UploadFileByOSSRequest) (<-chan *UploadFileByOSSResponse, <-chan error) {
	responseChan := make(chan *UploadFileByOSSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadFileByOSS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadFileByOSSWithCallback invokes the grace.UploadFileByOSS API asynchronously
func (client *Client) UploadFileByOSSWithCallback(request *UploadFileByOSSRequest, callback func(response *UploadFileByOSSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadFileByOSSResponse
		var err error
		defer close(result)
		response, err = client.UploadFileByOSS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadFileByOSSRequest is the request struct for api UploadFileByOSS
type UploadFileByOSSRequest struct {
	*requests.RoaRequest
	ObjectName  string `position:"Query" name:"objectName"`
	Type        string `position:"Query" name:"type"`
	Endpoint    string `position:"Query" name:"endpoint"`
	BucketName  string `position:"Query" name:"bucketName"`
	DisplayName string `position:"Query" name:"displayName"`
}

// UploadFileByOSSResponse is the response struct for api UploadFileByOSS
type UploadFileByOSSResponse struct {
	*responses.BaseResponse
	Name      string `json:"name" xml:"name"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateUploadFileByOSSRequest creates a request to invoke UploadFileByOSS API
func CreateUploadFileByOSSRequest() (request *UploadFileByOSSRequest) {
	request = &UploadFileByOSSRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("grace", "2022-06-06", "UploadFileByOSS", "/UploadFileByOSS", "grace", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadFileByOSSResponse creates a response to parse from UploadFileByOSS response
func CreateUploadFileByOSSResponse() (response *UploadFileByOSSResponse) {
	response = &UploadFileByOSSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
