package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSubnet invokes the eflo.UpdateSubnet API synchronously
func (client *Client) UpdateSubnet(request *UpdateSubnetRequest) (response *UpdateSubnetResponse, err error) {
	response = CreateUpdateSubnetResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSubnetWithChan invokes the eflo.UpdateSubnet API asynchronously
func (client *Client) UpdateSubnetWithChan(request *UpdateSubnetRequest) (<-chan *UpdateSubnetResponse, <-chan error) {
	responseChan := make(chan *UpdateSubnetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSubnet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSubnetWithCallback invokes the eflo.UpdateSubnet API asynchronously
func (client *Client) UpdateSubnetWithCallback(request *UpdateSubnetRequest, callback func(response *UpdateSubnetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSubnetResponse
		var err error
		defer close(result)
		response, err = client.UpdateSubnet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSubnetRequest is the request struct for api UpdateSubnet
type UpdateSubnetRequest struct {
	*requests.RpcRequest
	SubnetId   string `position:"Body" name:"SubnetId"`
	VpdId      string `position:"Body" name:"VpdId"`
	ZoneId     string `position:"Body" name:"ZoneId"`
	SubnetName string `position:"Body" name:"SubnetName"`
}

// UpdateSubnetResponse is the response struct for api UpdateSubnet
type UpdateSubnetResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateUpdateSubnetRequest creates a request to invoke UpdateSubnet API
func CreateUpdateSubnetRequest() (request *UpdateSubnetRequest) {
	request = &UpdateSubnetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UpdateSubnet", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSubnetResponse creates a response to parse from UpdateSubnet response
func CreateUpdateSubnetResponse() (response *UpdateSubnetResponse) {
	response = &UpdateSubnetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
