package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewElasticityAssurances invokes the ecs.RenewElasticityAssurances API synchronously
func (client *Client) RenewElasticityAssurances(request *RenewElasticityAssurancesRequest) (response *RenewElasticityAssurancesResponse, err error) {
	response = CreateRenewElasticityAssurancesResponse()
	err = client.DoAction(request, response)
	return
}

// RenewElasticityAssurancesWithChan invokes the ecs.RenewElasticityAssurances API asynchronously
func (client *Client) RenewElasticityAssurancesWithChan(request *RenewElasticityAssurancesRequest) (<-chan *RenewElasticityAssurancesResponse, <-chan error) {
	responseChan := make(chan *RenewElasticityAssurancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewElasticityAssurances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewElasticityAssurancesWithCallback invokes the ecs.RenewElasticityAssurances API asynchronously
func (client *Client) RenewElasticityAssurancesWithCallback(request *RenewElasticityAssurancesRequest, callback func(response *RenewElasticityAssurancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewElasticityAssurancesResponse
		var err error
		defer close(result)
		response, err = client.RenewElasticityAssurances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewElasticityAssurancesRequest is the request struct for api RenewElasticityAssurances
type RenewElasticityAssurancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	PrivatePoolOptionsId *[]string        `position:"Query" name:"PrivatePoolOptions.Id"  type:"Repeated"`
	Period               requests.Integer `position:"Query" name:"Period"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PeriodUnit           string           `position:"Query" name:"PeriodUnit"`
}

// RenewElasticityAssurancesResponse is the response struct for api RenewElasticityAssurances
type RenewElasticityAssurancesResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	OrderId                 string                  `json:"OrderId" xml:"OrderId"`
	PrivatePoolOptionsIdSet PrivatePoolOptionsIdSet `json:"PrivatePoolOptionsIdSet" xml:"PrivatePoolOptionsIdSet"`
}

// CreateRenewElasticityAssurancesRequest creates a request to invoke RenewElasticityAssurances API
func CreateRenewElasticityAssurancesRequest() (request *RenewElasticityAssurancesRequest) {
	request = &RenewElasticityAssurancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "RenewElasticityAssurances", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewElasticityAssurancesResponse creates a response to parse from RenewElasticityAssurances response
func CreateRenewElasticityAssurancesResponse() (response *RenewElasticityAssurancesResponse) {
	response = &RenewElasticityAssurancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
