package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDesktops invokes the ecd.DeleteDesktops API synchronously
func (client *Client) DeleteDesktops(request *DeleteDesktopsRequest) (response *DeleteDesktopsResponse, err error) {
	response = CreateDeleteDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDesktopsWithChan invokes the ecd.DeleteDesktops API asynchronously
func (client *Client) DeleteDesktopsWithChan(request *DeleteDesktopsRequest) (<-chan *DeleteDesktopsResponse, <-chan error) {
	responseChan := make(chan *DeleteDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDesktopsWithCallback invokes the ecd.DeleteDesktops API asynchronously
func (client *Client) DeleteDesktopsWithCallback(request *DeleteDesktopsRequest, callback func(response *DeleteDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDesktopsResponse
		var err error
		defer close(result)
		response, err = client.DeleteDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDesktopsRequest is the request struct for api DeleteDesktops
type DeleteDesktopsRequest struct {
	*requests.RpcRequest
	DesktopId *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// DeleteDesktopsResponse is the response struct for api DeleteDesktops
type DeleteDesktopsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDesktopsRequest creates a request to invoke DeleteDesktops API
func CreateDeleteDesktopsRequest() (request *DeleteDesktopsRequest) {
	request = &DeleteDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteDesktops", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDesktopsResponse creates a response to parse from DeleteDesktops response
func CreateDeleteDesktopsResponse() (response *DeleteDesktopsResponse) {
	response = &DeleteDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
