package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JyCreateVerifyScheme invokes the dypnsapi.JyCreateVerifyScheme API synchronously
func (client *Client) JyCreateVerifyScheme(request *JyCreateVerifySchemeRequest) (response *JyCreateVerifySchemeResponse, err error) {
	response = CreateJyCreateVerifySchemeResponse()
	err = client.DoAction(request, response)
	return
}

// JyCreateVerifySchemeWithChan invokes the dypnsapi.JyCreateVerifyScheme API asynchronously
func (client *Client) JyCreateVerifySchemeWithChan(request *JyCreateVerifySchemeRequest) (<-chan *JyCreateVerifySchemeResponse, <-chan error) {
	responseChan := make(chan *JyCreateVerifySchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JyCreateVerifyScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JyCreateVerifySchemeWithCallback invokes the dypnsapi.JyCreateVerifyScheme API asynchronously
func (client *Client) JyCreateVerifySchemeWithCallback(request *JyCreateVerifySchemeRequest, callback func(response *JyCreateVerifySchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JyCreateVerifySchemeResponse
		var err error
		defer close(result)
		response, err = client.JyCreateVerifyScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JyCreateVerifySchemeRequest is the request struct for api JyCreateVerifyScheme
type JyCreateVerifySchemeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BundleId             string           `position:"Query" name:"BundleId"`
	AppName              string           `position:"Query" name:"AppName"`
	PackSign             string           `position:"Query" name:"PackSign"`
	PackName             string           `position:"Query" name:"PackName"`
	CuApiCode            requests.Integer `position:"Query" name:"CuApiCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CtApiCode            requests.Integer `position:"Query" name:"CtApiCode"`
	OsType               string           `position:"Query" name:"OsType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CmApiCode            requests.Integer `position:"Query" name:"CmApiCode"`
	SchemeName           string           `position:"Query" name:"SchemeName"`
}

// JyCreateVerifySchemeResponse is the response struct for api JyCreateVerifyScheme
type JyCreateVerifySchemeResponse struct {
	*responses.BaseResponse
	Code                 string               `json:"Code" xml:"Code"`
	Message              string               `json:"Message" xml:"Message"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	GateVerifySchemeData GateVerifySchemeData `json:"GateVerifySchemeData" xml:"GateVerifySchemeData"`
}

// CreateJyCreateVerifySchemeRequest creates a request to invoke JyCreateVerifyScheme API
func CreateJyCreateVerifySchemeRequest() (request *JyCreateVerifySchemeRequest) {
	request = &JyCreateVerifySchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "JyCreateVerifyScheme", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJyCreateVerifySchemeResponse creates a response to parse from JyCreateVerifyScheme response
func CreateJyCreateVerifySchemeResponse() (response *JyCreateVerifySchemeResponse) {
	response = &JyCreateVerifySchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
