package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAxgGroup invokes the dyplsapi.DeleteAxgGroup API synchronously
func (client *Client) DeleteAxgGroup(request *DeleteAxgGroupRequest) (response *DeleteAxgGroupResponse, err error) {
	response = CreateDeleteAxgGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAxgGroupWithChan invokes the dyplsapi.DeleteAxgGroup API asynchronously
func (client *Client) DeleteAxgGroupWithChan(request *DeleteAxgGroupRequest) (<-chan *DeleteAxgGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteAxgGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAxgGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAxgGroupWithCallback invokes the dyplsapi.DeleteAxgGroup API asynchronously
func (client *Client) DeleteAxgGroupWithCallback(request *DeleteAxgGroupRequest, callback func(response *DeleteAxgGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAxgGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteAxgGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAxgGroupRequest is the request struct for api DeleteAxgGroup
type DeleteAxgGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	GroupId              requests.Integer `position:"Query" name:"GroupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// DeleteAxgGroupResponse is the response struct for api DeleteAxgGroup
type DeleteAxgGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAxgGroupRequest creates a request to invoke DeleteAxgGroup API
func CreateDeleteAxgGroupRequest() (request *DeleteAxgGroupRequest) {
	request = &DeleteAxgGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "DeleteAxgGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAxgGroupResponse creates a response to parse from DeleteAxgGroup response
func CreateDeleteAxgGroupResponse() (response *DeleteAxgGroupResponse) {
	response = &DeleteAxgGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
