package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcIpWorksCopyright invokes the dt_oc_info.GetOcIpWorksCopyright API synchronously
func (client *Client) GetOcIpWorksCopyright(request *GetOcIpWorksCopyrightRequest) (response *GetOcIpWorksCopyrightResponse, err error) {
	response = CreateGetOcIpWorksCopyrightResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcIpWorksCopyrightWithChan invokes the dt_oc_info.GetOcIpWorksCopyright API asynchronously
func (client *Client) GetOcIpWorksCopyrightWithChan(request *GetOcIpWorksCopyrightRequest) (<-chan *GetOcIpWorksCopyrightResponse, <-chan error) {
	responseChan := make(chan *GetOcIpWorksCopyrightResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcIpWorksCopyright(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcIpWorksCopyrightWithCallback invokes the dt_oc_info.GetOcIpWorksCopyright API asynchronously
func (client *Client) GetOcIpWorksCopyrightWithCallback(request *GetOcIpWorksCopyrightRequest, callback func(response *GetOcIpWorksCopyrightResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcIpWorksCopyrightResponse
		var err error
		defer close(result)
		response, err = client.GetOcIpWorksCopyright(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcIpWorksCopyrightRequest is the request struct for api GetOcIpWorksCopyright
type GetOcIpWorksCopyrightRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcIpWorksCopyrightResponse is the response struct for api GetOcIpWorksCopyright
type GetOcIpWorksCopyrightResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcIpWorksCopyrightRequest creates a request to invoke GetOcIpWorksCopyright API
func CreateGetOcIpWorksCopyrightRequest() (request *GetOcIpWorksCopyrightRequest) {
	request = &GetOcIpWorksCopyrightRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcIpWorksCopyright", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcIpWorksCopyrightResponse creates a response to parse from GetOcIpWorksCopyright response
func CreateGetOcIpWorksCopyrightResponse() (response *GetOcIpWorksCopyrightResponse) {
	response = &GetOcIpWorksCopyrightResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
