package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAutoCcWhitelist invokes the ddoscoo.DeleteAutoCcWhitelist API synchronously
func (client *Client) DeleteAutoCcWhitelist(request *DeleteAutoCcWhitelistRequest) (response *DeleteAutoCcWhitelistResponse, err error) {
	response = CreateDeleteAutoCcWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAutoCcWhitelistWithChan invokes the ddoscoo.DeleteAutoCcWhitelist API asynchronously
func (client *Client) DeleteAutoCcWhitelistWithChan(request *DeleteAutoCcWhitelistRequest) (<-chan *DeleteAutoCcWhitelistResponse, <-chan error) {
	responseChan := make(chan *DeleteAutoCcWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAutoCcWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAutoCcWhitelistWithCallback invokes the ddoscoo.DeleteAutoCcWhitelist API asynchronously
func (client *Client) DeleteAutoCcWhitelistWithCallback(request *DeleteAutoCcWhitelistRequest, callback func(response *DeleteAutoCcWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAutoCcWhitelistResponse
		var err error
		defer close(result)
		response, err = client.DeleteAutoCcWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAutoCcWhitelistRequest is the request struct for api DeleteAutoCcWhitelist
type DeleteAutoCcWhitelistRequest struct {
	*requests.RpcRequest
	Whitelist  string `position:"Query" name:"Whitelist"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// DeleteAutoCcWhitelistResponse is the response struct for api DeleteAutoCcWhitelist
type DeleteAutoCcWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAutoCcWhitelistRequest creates a request to invoke DeleteAutoCcWhitelist API
func CreateDeleteAutoCcWhitelistRequest() (request *DeleteAutoCcWhitelistRequest) {
	request = &DeleteAutoCcWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteAutoCcWhitelist", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAutoCcWhitelistResponse creates a response to parse from DeleteAutoCcWhitelist response
func CreateDeleteAutoCcWhitelistResponse() (response *DeleteAutoCcWhitelistResponse) {
	response = &DeleteAutoCcWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
