package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafRule invokes the dcdn.DescribeDcdnWafRule API synchronously
func (client *Client) DescribeDcdnWafRule(request *DescribeDcdnWafRuleRequest) (response *DescribeDcdnWafRuleResponse, err error) {
	response = CreateDescribeDcdnWafRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafRuleWithChan invokes the dcdn.DescribeDcdnWafRule API asynchronously
func (client *Client) DescribeDcdnWafRuleWithChan(request *DescribeDcdnWafRuleRequest) (<-chan *DescribeDcdnWafRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafRuleWithCallback invokes the dcdn.DescribeDcdnWafRule API asynchronously
func (client *Client) DescribeDcdnWafRuleWithCallback(request *DescribeDcdnWafRuleRequest, callback func(response *DescribeDcdnWafRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafRuleRequest is the request struct for api DescribeDcdnWafRule
type DescribeDcdnWafRuleRequest struct {
	*requests.RpcRequest
	RuleId requests.Integer `position:"Query" name:"RuleId"`
}

// DescribeDcdnWafRuleResponse is the response struct for api DescribeDcdnWafRule
type DescribeDcdnWafRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Rule      Rule   `json:"Rule" xml:"Rule"`
}

// CreateDescribeDcdnWafRuleRequest creates a request to invoke DescribeDcdnWafRule API
func CreateDescribeDcdnWafRuleRequest() (request *DescribeDcdnWafRuleRequest) {
	request = &DescribeDcdnWafRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafRuleResponse creates a response to parse from DescribeDcdnWafRule response
func CreateDescribeDcdnWafRuleResponse() (response *DescribeDcdnWafRuleResponse) {
	response = &DescribeDcdnWafRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
