package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgDesensPlanQueryList invokes the dataworks_public.DsgDesensPlanQueryList API synchronously
func (client *Client) DsgDesensPlanQueryList(request *DsgDesensPlanQueryListRequest) (response *DsgDesensPlanQueryListResponse, err error) {
	response = CreateDsgDesensPlanQueryListResponse()
	err = client.DoAction(request, response)
	return
}

// DsgDesensPlanQueryListWithChan invokes the dataworks_public.DsgDesensPlanQueryList API asynchronously
func (client *Client) DsgDesensPlanQueryListWithChan(request *DsgDesensPlanQueryListRequest) (<-chan *DsgDesensPlanQueryListResponse, <-chan error) {
	responseChan := make(chan *DsgDesensPlanQueryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgDesensPlanQueryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgDesensPlanQueryListWithCallback invokes the dataworks_public.DsgDesensPlanQueryList API asynchronously
func (client *Client) DsgDesensPlanQueryListWithCallback(request *DsgDesensPlanQueryListRequest, callback func(response *DsgDesensPlanQueryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgDesensPlanQueryListResponse
		var err error
		defer close(result)
		response, err = client.DsgDesensPlanQueryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgDesensPlanQueryListRequest is the request struct for api DsgDesensPlanQueryList
type DsgDesensPlanQueryListRequest struct {
	*requests.RpcRequest
	Owner      string           `position:"Query" name:"Owner"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	SceneId    requests.Integer `position:"Query" name:"SceneId"`
	RuleName   string           `position:"Query" name:"RuleName"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Status     requests.Integer `position:"Query" name:"Status"`
}

// DsgDesensPlanQueryListResponse is the response struct for api DsgDesensPlanQueryList
type DsgDesensPlanQueryListResponse struct {
	*responses.BaseResponse
	Success        bool     `json:"Success" xml:"Success"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	PageData       PageData `json:"PageData" xml:"PageData"`
}

// CreateDsgDesensPlanQueryListRequest creates a request to invoke DsgDesensPlanQueryList API
func CreateDsgDesensPlanQueryListRequest() (request *DsgDesensPlanQueryListRequest) {
	request = &DsgDesensPlanQueryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgDesensPlanQueryList", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgDesensPlanQueryListResponse creates a response to parse from DsgDesensPlanQueryList response
func CreateDsgDesensPlanQueryListResponse() (response *DsgDesensPlanQueryListResponse) {
	response = &DsgDesensPlanQueryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
