package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ContinueDeployServiceInstance invokes the computenest.ContinueDeployServiceInstance API synchronously
func (client *Client) ContinueDeployServiceInstance(request *ContinueDeployServiceInstanceRequest) (response *ContinueDeployServiceInstanceResponse, err error) {
	response = CreateContinueDeployServiceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ContinueDeployServiceInstanceWithChan invokes the computenest.ContinueDeployServiceInstance API asynchronously
func (client *Client) ContinueDeployServiceInstanceWithChan(request *ContinueDeployServiceInstanceRequest) (<-chan *ContinueDeployServiceInstanceResponse, <-chan error) {
	responseChan := make(chan *ContinueDeployServiceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ContinueDeployServiceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ContinueDeployServiceInstanceWithCallback invokes the computenest.ContinueDeployServiceInstance API asynchronously
func (client *Client) ContinueDeployServiceInstanceWithCallback(request *ContinueDeployServiceInstanceRequest, callback func(response *ContinueDeployServiceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ContinueDeployServiceInstanceResponse
		var err error
		defer close(result)
		response, err = client.ContinueDeployServiceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ContinueDeployServiceInstanceRequest is the request struct for api ContinueDeployServiceInstance
type ContinueDeployServiceInstanceRequest struct {
	*requests.RpcRequest
	ClientToken       string           `position:"Query" name:"ClientToken"`
	ServiceInstanceId string           `position:"Query" name:"ServiceInstanceId"`
	DryRun            requests.Boolean `position:"Query" name:"DryRun"`
	Parameters        string           `position:"Query" name:"Parameters"`
	Option            *[]string        `position:"Query" name:"Option"  type:"Repeated"`
}

// ContinueDeployServiceInstanceResponse is the response struct for api ContinueDeployServiceInstance
type ContinueDeployServiceInstanceResponse struct {
	*responses.BaseResponse
	RequestId         string       `json:"RequestId" xml:"RequestId"`
	ServiceInstanceId string       `json:"ServiceInstanceId" xml:"ServiceInstanceId"`
	DryRunResult      DryRunResult `json:"DryRunResult" xml:"DryRunResult"`
}

// CreateContinueDeployServiceInstanceRequest creates a request to invoke ContinueDeployServiceInstance API
func CreateContinueDeployServiceInstanceRequest() (request *ContinueDeployServiceInstanceRequest) {
	request = &ContinueDeployServiceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "ContinueDeployServiceInstance", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateContinueDeployServiceInstanceResponse creates a response to parse from ContinueDeployServiceInstance response
func CreateContinueDeployServiceInstanceResponse() (response *ContinueDeployServiceInstanceResponse) {
	response = &ContinueDeployServiceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
