package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPolicyAdvancedConfig invokes the cloudfw.ModifyPolicyAdvancedConfig API synchronously
func (client *Client) ModifyPolicyAdvancedConfig(request *ModifyPolicyAdvancedConfigRequest) (response *ModifyPolicyAdvancedConfigResponse, err error) {
	response = CreateModifyPolicyAdvancedConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPolicyAdvancedConfigWithChan invokes the cloudfw.ModifyPolicyAdvancedConfig API asynchronously
func (client *Client) ModifyPolicyAdvancedConfigWithChan(request *ModifyPolicyAdvancedConfigRequest) (<-chan *ModifyPolicyAdvancedConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyPolicyAdvancedConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPolicyAdvancedConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPolicyAdvancedConfigWithCallback invokes the cloudfw.ModifyPolicyAdvancedConfig API asynchronously
func (client *Client) ModifyPolicyAdvancedConfigWithCallback(request *ModifyPolicyAdvancedConfigRequest, callback func(response *ModifyPolicyAdvancedConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPolicyAdvancedConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyPolicyAdvancedConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPolicyAdvancedConfigRequest is the request struct for api ModifyPolicyAdvancedConfig
type ModifyPolicyAdvancedConfigRequest struct {
	*requests.RpcRequest
	InternetSwitch string `position:"Query" name:"InternetSwitch"`
	SourceIp       string `position:"Query" name:"SourceIp"`
	Lang           string `position:"Query" name:"Lang"`
}

// ModifyPolicyAdvancedConfigResponse is the response struct for api ModifyPolicyAdvancedConfig
type ModifyPolicyAdvancedConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPolicyAdvancedConfigRequest creates a request to invoke ModifyPolicyAdvancedConfig API
func CreateModifyPolicyAdvancedConfigRequest() (request *ModifyPolicyAdvancedConfigRequest) {
	request = &ModifyPolicyAdvancedConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyPolicyAdvancedConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPolicyAdvancedConfigResponse creates a response to parse from ModifyPolicyAdvancedConfig response
func CreateModifyPolicyAdvancedConfigResponse() (response *ModifyPolicyAdvancedConfigResponse) {
	response = &ModifyPolicyAdvancedConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
