package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddInstanceMembers invokes the cloudfw.AddInstanceMembers API synchronously
func (client *Client) AddInstanceMembers(request *AddInstanceMembersRequest) (response *AddInstanceMembersResponse, err error) {
	response = CreateAddInstanceMembersResponse()
	err = client.DoAction(request, response)
	return
}

// AddInstanceMembersWithChan invokes the cloudfw.AddInstanceMembers API asynchronously
func (client *Client) AddInstanceMembersWithChan(request *AddInstanceMembersRequest) (<-chan *AddInstanceMembersResponse, <-chan error) {
	responseChan := make(chan *AddInstanceMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddInstanceMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddInstanceMembersWithCallback invokes the cloudfw.AddInstanceMembers API asynchronously
func (client *Client) AddInstanceMembersWithCallback(request *AddInstanceMembersRequest, callback func(response *AddInstanceMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddInstanceMembersResponse
		var err error
		defer close(result)
		response, err = client.AddInstanceMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddInstanceMembersRequest is the request struct for api AddInstanceMembers
type AddInstanceMembersRequest struct {
	*requests.RpcRequest
	SourceIp string                       `position:"Query" name:"SourceIp"`
	Members  *[]AddInstanceMembersMembers `position:"Query" name:"Members"  type:"Repeated"`
	Lang     string                       `position:"Query" name:"Lang"`
}

// AddInstanceMembersMembers is a repeated param struct in AddInstanceMembersRequest
type AddInstanceMembersMembers struct {
	MemberUid  string `name:"MemberUid"`
	MemberDesc string `name:"MemberDesc"`
}

// AddInstanceMembersResponse is the response struct for api AddInstanceMembers
type AddInstanceMembersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddInstanceMembersRequest creates a request to invoke AddInstanceMembers API
func CreateAddInstanceMembersRequest() (request *AddInstanceMembersRequest) {
	request = &AddInstanceMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "AddInstanceMembers", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddInstanceMembersResponse creates a response to parse from AddInstanceMembers response
func CreateAddInstanceMembersResponse() (response *AddInstanceMembersResponse) {
	response = &AddInstanceMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
