package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCompanyTemplate invokes the cloudesl.AddCompanyTemplate API synchronously
func (client *Client) AddCompanyTemplate(request *AddCompanyTemplateRequest) (response *AddCompanyTemplateResponse, err error) {
	response = CreateAddCompanyTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// AddCompanyTemplateWithChan invokes the cloudesl.AddCompanyTemplate API asynchronously
func (client *Client) AddCompanyTemplateWithChan(request *AddCompanyTemplateRequest) (<-chan *AddCompanyTemplateResponse, <-chan error) {
	responseChan := make(chan *AddCompanyTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCompanyTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCompanyTemplateWithCallback invokes the cloudesl.AddCompanyTemplate API asynchronously
func (client *Client) AddCompanyTemplateWithCallback(request *AddCompanyTemplateRequest, callback func(response *AddCompanyTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCompanyTemplateResponse
		var err error
		defer close(result)
		response, err = client.AddCompanyTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCompanyTemplateRequest is the request struct for api AddCompanyTemplate
type AddCompanyTemplateRequest struct {
	*requests.RpcRequest
	ExtraParams      string           `position:"Body" name:"ExtraParams"`
	EslSize          string           `position:"Body" name:"EslSize"`
	IfPromotion      requests.Boolean `position:"Body" name:"IfPromotion"`
	DeviceType       string           `position:"Body" name:"DeviceType"`
	Scene            string           `position:"Body" name:"Scene"`
	TemplateVersion  string           `position:"Body" name:"TemplateVersion"`
	TemplateType     string           `position:"Body" name:"TemplateType"`
	Vendor           string           `position:"Body" name:"Vendor"`
	IfDefault        requests.Boolean `position:"Body" name:"IfDefault"`
	TemplateName     string           `position:"Body" name:"TemplateName"`
	TemplateSceneId  string           `position:"Body" name:"TemplateSceneId"`
	IfSourceCode     requests.Boolean `position:"Body" name:"IfSourceCode"`
	GroupId          string           `position:"Body" name:"GroupId"`
	IfMember         requests.Boolean `position:"Body" name:"IfMember"`
	Layout           requests.Integer `position:"Body" name:"Layout"`
	IfOutOfInventory requests.Boolean `position:"Body" name:"IfOutOfInventory"`
}

// AddCompanyTemplateResponse is the response struct for api AddCompanyTemplate
type AddCompanyTemplateResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateAddCompanyTemplateRequest creates a request to invoke AddCompanyTemplate API
func CreateAddCompanyTemplateRequest() (request *AddCompanyTemplateRequest) {
	request = &AddCompanyTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "AddCompanyTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateAddCompanyTemplateResponse creates a response to parse from AddCompanyTemplate response
func CreateAddCompanyTemplateResponse() (response *AddCompanyTemplateResponse) {
	response = &AddCompanyTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
