package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventCountByThreatLevel invokes the cloud_siem.DescribeEventCountByThreatLevel API synchronously
func (client *Client) DescribeEventCountByThreatLevel(request *DescribeEventCountByThreatLevelRequest) (response *DescribeEventCountByThreatLevelResponse, err error) {
	response = CreateDescribeEventCountByThreatLevelResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventCountByThreatLevelWithChan invokes the cloud_siem.DescribeEventCountByThreatLevel API asynchronously
func (client *Client) DescribeEventCountByThreatLevelWithChan(request *DescribeEventCountByThreatLevelRequest) (<-chan *DescribeEventCountByThreatLevelResponse, <-chan error) {
	responseChan := make(chan *DescribeEventCountByThreatLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventCountByThreatLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventCountByThreatLevelWithCallback invokes the cloud_siem.DescribeEventCountByThreatLevel API asynchronously
func (client *Client) DescribeEventCountByThreatLevelWithCallback(request *DescribeEventCountByThreatLevelRequest, callback func(response *DescribeEventCountByThreatLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventCountByThreatLevelResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventCountByThreatLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventCountByThreatLevelRequest is the request struct for api DescribeEventCountByThreatLevel
type DescribeEventCountByThreatLevelRequest struct {
	*requests.RpcRequest
}

// DescribeEventCountByThreatLevelResponse is the response struct for api DescribeEventCountByThreatLevel
type DescribeEventCountByThreatLevelResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeEventCountByThreatLevelRequest creates a request to invoke DescribeEventCountByThreatLevel API
func CreateDescribeEventCountByThreatLevelRequest() (request *DescribeEventCountByThreatLevelRequest) {
	request = &DescribeEventCountByThreatLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeEventCountByThreatLevel", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEventCountByThreatLevelResponse creates a response to parse from DescribeEventCountByThreatLevel response
func CreateDescribeEventCountByThreatLevelResponse() (response *DescribeEventCountByThreatLevelResponse) {
	response = &DescribeEventCountByThreatLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
