package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountAuthority invokes the clickhouse.DescribeAccountAuthority API synchronously
func (client *Client) DescribeAccountAuthority(request *DescribeAccountAuthorityRequest) (response *DescribeAccountAuthorityResponse, err error) {
	response = CreateDescribeAccountAuthorityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountAuthorityWithChan invokes the clickhouse.DescribeAccountAuthority API asynchronously
func (client *Client) DescribeAccountAuthorityWithChan(request *DescribeAccountAuthorityRequest) (<-chan *DescribeAccountAuthorityResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountAuthorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountAuthority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountAuthorityWithCallback invokes the clickhouse.DescribeAccountAuthority API asynchronously
func (client *Client) DescribeAccountAuthorityWithCallback(request *DescribeAccountAuthorityRequest, callback func(response *DescribeAccountAuthorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountAuthorityResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountAuthority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountAuthorityRequest is the request struct for api DescribeAccountAuthority
type DescribeAccountAuthorityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AccountName          string           `position:"Query" name:"AccountName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAccountAuthorityResponse is the response struct for api DescribeAccountAuthority
type DescribeAccountAuthorityResponse struct {
	*responses.BaseResponse
	DdlAuthority      bool     `json:"DdlAuthority" xml:"DdlAuthority"`
	DmlAuthority      string   `json:"DmlAuthority" xml:"DmlAuthority"`
	RequestId         string   `json:"RequestId" xml:"RequestId"`
	AccountName       string   `json:"AccountName" xml:"AccountName"`
	TotalDatabases    []string `json:"TotalDatabases" xml:"TotalDatabases"`
	TotalDictionaries []string `json:"TotalDictionaries" xml:"TotalDictionaries"`
	AllowDictionaries []string `json:"AllowDictionaries" xml:"AllowDictionaries"`
	AllowDatabases    []string `json:"AllowDatabases" xml:"AllowDatabases"`
}

// CreateDescribeAccountAuthorityRequest creates a request to invoke DescribeAccountAuthority API
func CreateDescribeAccountAuthorityRequest() (request *DescribeAccountAuthorityRequest) {
	request = &DescribeAccountAuthorityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeAccountAuthority", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountAuthorityResponse creates a response to parse from DescribeAccountAuthority response
func CreateDescribeAccountAuthorityResponse() (response *DescribeAccountAuthorityResponse) {
	response = &DescribeAccountAuthorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
