package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCard invokes the cc5g.UpdateCard API synchronously
func (client *Client) UpdateCard(request *UpdateCardRequest) (response *UpdateCardResponse, err error) {
	response = CreateUpdateCardResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCardWithChan invokes the cc5g.UpdateCard API asynchronously
func (client *Client) UpdateCardWithChan(request *UpdateCardRequest) (<-chan *UpdateCardResponse, <-chan error) {
	responseChan := make(chan *UpdateCardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCardWithCallback invokes the cc5g.UpdateCard API asynchronously
func (client *Client) UpdateCardWithCallback(request *UpdateCardRequest, callback func(response *UpdateCardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCardResponse
		var err error
		defer close(result)
		response, err = client.UpdateCard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCardRequest is the request struct for api UpdateCard
type UpdateCardRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	Description              string           `position:"Query" name:"Description"`
	Iccid                    string           `position:"Query" name:"Iccid"`
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	Name                     string           `position:"Query" name:"Name"`
}

// UpdateCardResponse is the response struct for api UpdateCard
type UpdateCardResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCardRequest creates a request to invoke UpdateCard API
func CreateUpdateCardRequest() (request *UpdateCardRequest) {
	request = &UpdateCardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateCard", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCardResponse creates a response to parse from UpdateCard response
func CreateUpdateCardResponse() (response *UpdateCardResponse) {
	response = &UpdateCardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
