package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTransitRouterEcrAttachments invokes the cbn.ListTransitRouterEcrAttachments API synchronously
func (client *Client) ListTransitRouterEcrAttachments(request *ListTransitRouterEcrAttachmentsRequest) (response *ListTransitRouterEcrAttachmentsResponse, err error) {
	response = CreateListTransitRouterEcrAttachmentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTransitRouterEcrAttachmentsWithChan invokes the cbn.ListTransitRouterEcrAttachments API asynchronously
func (client *Client) ListTransitRouterEcrAttachmentsWithChan(request *ListTransitRouterEcrAttachmentsRequest) (<-chan *ListTransitRouterEcrAttachmentsResponse, <-chan error) {
	responseChan := make(chan *ListTransitRouterEcrAttachmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTransitRouterEcrAttachments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTransitRouterEcrAttachmentsWithCallback invokes the cbn.ListTransitRouterEcrAttachments API asynchronously
func (client *Client) ListTransitRouterEcrAttachmentsWithCallback(request *ListTransitRouterEcrAttachmentsRequest, callback func(response *ListTransitRouterEcrAttachmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTransitRouterEcrAttachmentsResponse
		var err error
		defer close(result)
		response, err = client.ListTransitRouterEcrAttachments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTransitRouterEcrAttachmentsRequest is the request struct for api ListTransitRouterEcrAttachments
type ListTransitRouterEcrAttachmentsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	CenId                     string                                `position:"Query" name:"CenId"`
	NextToken                 string                                `position:"Query" name:"NextToken"`
	Tag                       *[]ListTransitRouterEcrAttachmentsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount      string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string                                `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer                      `position:"Query" name:"OwnerId"`
	TransitRouterId           string                                `position:"Query" name:"TransitRouterId"`
	ResourceType              string                                `position:"Query" name:"ResourceType"`
	Version                   string                                `position:"Query" name:"Version"`
	TransitRouterAttachmentId string                                `position:"Query" name:"TransitRouterAttachmentId"`
	MaxResults                requests.Integer                      `position:"Query" name:"MaxResults"`
}

// ListTransitRouterEcrAttachmentsTag is a repeated param struct in ListTransitRouterEcrAttachmentsRequest
type ListTransitRouterEcrAttachmentsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListTransitRouterEcrAttachmentsResponse is the response struct for api ListTransitRouterEcrAttachments
type ListTransitRouterEcrAttachmentsResponse struct {
	*responses.BaseResponse
	NextToken                string                    `json:"NextToken" xml:"NextToken"`
	RequestId                string                    `json:"RequestId" xml:"RequestId"`
	TotalCount               int                       `json:"TotalCount" xml:"TotalCount"`
	MaxResults               int                       `json:"MaxResults" xml:"MaxResults"`
	TransitRouterAttachments []TransitRouterAttachment `json:"TransitRouterAttachments" xml:"TransitRouterAttachments"`
}

// CreateListTransitRouterEcrAttachmentsRequest creates a request to invoke ListTransitRouterEcrAttachments API
func CreateListTransitRouterEcrAttachmentsRequest() (request *ListTransitRouterEcrAttachmentsRequest) {
	request = &ListTransitRouterEcrAttachmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTransitRouterEcrAttachments", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTransitRouterEcrAttachmentsResponse creates a response to parse from ListTransitRouterEcrAttachments response
func CreateListTransitRouterEcrAttachmentsResponse() (response *ListTransitRouterEcrAttachmentsResponse) {
	response = &ListTransitRouterEcrAttachmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
