package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTransitRouteTableAggregation invokes the cbn.DescribeTransitRouteTableAggregation API synchronously
func (client *Client) DescribeTransitRouteTableAggregation(request *DescribeTransitRouteTableAggregationRequest) (response *DescribeTransitRouteTableAggregationResponse, err error) {
	response = CreateDescribeTransitRouteTableAggregationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTransitRouteTableAggregationWithChan invokes the cbn.DescribeTransitRouteTableAggregation API asynchronously
func (client *Client) DescribeTransitRouteTableAggregationWithChan(request *DescribeTransitRouteTableAggregationRequest) (<-chan *DescribeTransitRouteTableAggregationResponse, <-chan error) {
	responseChan := make(chan *DescribeTransitRouteTableAggregationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTransitRouteTableAggregation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTransitRouteTableAggregationWithCallback invokes the cbn.DescribeTransitRouteTableAggregation API asynchronously
func (client *Client) DescribeTransitRouteTableAggregationWithCallback(request *DescribeTransitRouteTableAggregationRequest, callback func(response *DescribeTransitRouteTableAggregationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTransitRouteTableAggregationResponse
		var err error
		defer close(result)
		response, err = client.DescribeTransitRouteTableAggregation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTransitRouteTableAggregationRequest is the request struct for api DescribeTransitRouteTableAggregation
type DescribeTransitRouteTableAggregationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                      string           `position:"Query" name:"ClientToken"`
	NextToken                        string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount             string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                     string           `position:"Query" name:"OwnerAccount"`
	OwnerId                          requests.Integer `position:"Query" name:"OwnerId"`
	Version                          string           `position:"Query" name:"Version"`
	TransitRouteTableId              string           `position:"Query" name:"TransitRouteTableId"`
	TransitRouteTableAggregationCidr string           `position:"Query" name:"TransitRouteTableAggregationCidr"`
	MaxResults                       requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeTransitRouteTableAggregationResponse is the response struct for api DescribeTransitRouteTableAggregation
type DescribeTransitRouteTableAggregationResponse struct {
	*responses.BaseResponse
	Count     int        `json:"Count" xml:"Count"`
	NextToken string     `json:"NextToken" xml:"NextToken"`
	Total     int        `json:"Total" xml:"Total"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeTransitRouteTableAggregationRequest creates a request to invoke DescribeTransitRouteTableAggregation API
func CreateDescribeTransitRouteTableAggregationRequest() (request *DescribeTransitRouteTableAggregationRequest) {
	request = &DescribeTransitRouteTableAggregationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeTransitRouteTableAggregation", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTransitRouteTableAggregationResponse creates a response to parse from DescribeTransitRouteTableAggregation response
func CreateDescribeTransitRouteTableAggregationResponse() (response *DescribeTransitRouteTableAggregationResponse) {
	response = &DescribeTransitRouteTableAggregationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
