package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmAvatar2dTrain invokes the avatar.ConfirmAvatar2dTrain API synchronously
func (client *Client) ConfirmAvatar2dTrain(request *ConfirmAvatar2dTrainRequest) (response *ConfirmAvatar2dTrainResponse, err error) {
	response = CreateConfirmAvatar2dTrainResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmAvatar2dTrainWithChan invokes the avatar.ConfirmAvatar2dTrain API asynchronously
func (client *Client) ConfirmAvatar2dTrainWithChan(request *ConfirmAvatar2dTrainRequest) (<-chan *ConfirmAvatar2dTrainResponse, <-chan error) {
	responseChan := make(chan *ConfirmAvatar2dTrainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmAvatar2dTrain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmAvatar2dTrainWithCallback invokes the avatar.ConfirmAvatar2dTrain API asynchronously
func (client *Client) ConfirmAvatar2dTrainWithCallback(request *ConfirmAvatar2dTrainRequest, callback func(response *ConfirmAvatar2dTrainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmAvatar2dTrainResponse
		var err error
		defer close(result)
		response, err = client.ConfirmAvatar2dTrain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmAvatar2dTrainRequest is the request struct for api ConfirmAvatar2dTrain
type ConfirmAvatar2dTrainRequest struct {
	*requests.RpcRequest
	Confirm  string           `position:"Query" name:"Confirm"`
	Code     string           `position:"Query" name:"Code"`
	TenantId requests.Integer `position:"Query" name:"TenantId"`
}

// ConfirmAvatar2dTrainResponse is the response struct for api ConfirmAvatar2dTrain
type ConfirmAvatar2dTrainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateConfirmAvatar2dTrainRequest creates a request to invoke ConfirmAvatar2dTrain API
func CreateConfirmAvatar2dTrainRequest() (request *ConfirmAvatar2dTrainRequest) {
	request = &ConfirmAvatar2dTrainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "ConfirmAvatar2dTrain", "", "")
	request.Method = requests.POST
	return
}

// CreateConfirmAvatar2dTrainResponse creates a response to parse from ConfirmAvatar2dTrain response
func CreateConfirmAvatar2dTrainResponse() (response *ConfirmAvatar2dTrainResponse) {
	response = &ConfirmAvatar2dTrainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
