# Pinniped Governance

This document defines the project governance for Pinniped.

# Overview

**Pinniped** is committed to building an open, inclusive, productive and self-governing open source community focused on
building authentication services for Kubernetes clusters. The community is governed by this document which defines how
all members should work together to achieve this goal.

# Code of Conduct

The Pinniped community abides by this
[code of conduct](https://github.com/vmware-tanzu/pinniped/blob/main/CODE_OF_CONDUCT.md).

# Community Roles

* **Users:** Members that engage with the Pinniped community via any medium (Slack, GitHub, mailing lists, etc.).
* **Contributors:** Do regular contributions to the Pinniped project (documentation, code reviews, responding to issues,
  participating in proposal discussions, contributing code, etc.).
* **Maintainers:** Responsible for the overall health and direction of the project. They are the final reviewers of PRs
  and responsible for Pinniped releases.

# Maintainers

New maintainers must be nominated by an existing maintainer and must be elected by a supermajority of existing
maintainers. Likewise, maintainers can be removed by a supermajority of the existing maintainers or can resign by
notifying one of the maintainers.

**Note:** If a maintainer leaves their employer they are still considered a maintainer of Pinniped, unless they
voluntarily resign. Employment is not taken into consideration when determining maintainer eligibility unless the
company itself violates our [Code of Conduct](https://github.com/vmware-tanzu/pinniped/blob/main/CODE_OF_CONDUCT.md).

# Decision Making

Ideally, all project decisions are resolved by consensus. If impossible, any maintainer may call a vote. Unless
otherwise specified in this document, any vote will be decided by a supermajority of maintainers.

## Supermajority

A supermajority is defined as two-thirds of members in the group. A supermajority of maintainers is required for certain
decisions as outlined in this document. A supermajority vote is equivalent to the number of votes in favor being at
least twice the number of votes against. A vote to abstain equals not voting at all. For example, if you have 5
maintainers who all cast non-abstaining votes, then a supermajority vote is at least 4 votes in favor. Voting on
decisions can happen on the mailing list, GitHub, Slack, email, or via a voting service, when appropriate. Maintainers
can either vote "agree, yes, +1", "disagree, no, -1", or "abstain". A vote passes when supermajority is met.

## Lazy Consensus

To maintain velocity in Pinniped, the concept of [Lazy Consensus](http://en.osswiki.info/concepts/lazy_consensus) is
practiced.

Other maintainers may chime in and request additional time for review, but should remain cognizant of blocking progress
and abstain from delaying progress unless absolutely needed. The expectation is that blocking progress is accompanied by
a guarantee to review and respond to the relevant action in short order.

Lazy consensus does not apply to the process of:

* Removal of maintainers from Pinniped

## Updating Governance

All substantive changes in Governance, including substantive changes to the proposal process, require a supermajority
agreement by all maintainers.

# Proposal Process

The proposal process is defined in [proposals/README.md](proposals/README.md).
