// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { throwError as observableThrowError, Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CURRENT_BASE_HREF } from '../../../../shared/units/utils';

export abstract class ScanApiRepository {
    abstract postSchedule(param): Observable<any>;

    abstract putSchedule(param): Observable<any>;

    abstract getSchedule(): Observable<any>;
}

@Injectable()
export class ScanApiDefaultRepository extends ScanApiRepository {
    constructor(private http: HttpClient) {
        super();
    }

    public postSchedule(param): Observable<any> {
        return this.http
            .post(`${CURRENT_BASE_HREF}/system/scanAll/schedule`, param)
            .pipe(catchError(error => observableThrowError(error)));
    }

    public putSchedule(param): Observable<any> {
        return this.http
            .put(`${CURRENT_BASE_HREF}/system/scanAll/schedule`, param)
            .pipe(catchError(error => observableThrowError(error)));
    }

    public getSchedule(): Observable<any> {
        return this.http
            .get(`${CURRENT_BASE_HREF}/system/scanAll/schedule`)
            .pipe(catchError(error => observableThrowError(error)));
    }
}
