package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataCounts invokes the yundun_ds.DescribeDataCounts API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedatacounts.html
func (client *Client) DescribeDataCounts(request *DescribeDataCountsRequest) (response *DescribeDataCountsResponse, err error) {
	response = CreateDescribeDataCountsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataCountsWithChan invokes the yundun_ds.DescribeDataCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedatacounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataCountsWithChan(request *DescribeDataCountsRequest) (<-chan *DescribeDataCountsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataCountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataCounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataCountsWithCallback invokes the yundun_ds.DescribeDataCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedatacounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDataCountsWithCallback(request *DescribeDataCountsRequest, callback func(response *DescribeDataCountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataCountsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataCounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataCountsRequest is the request struct for api DescribeDataCounts
type DescribeDataCountsRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeDataCountsResponse is the response struct for api DescribeDataCounts
type DescribeDataCountsResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	DataCountList []DataCount `json:"DataCountList" xml:"DataCountList"`
}

// CreateDescribeDataCountsRequest creates a request to invoke DescribeDataCounts API
func CreateDescribeDataCountsRequest() (request *DescribeDataCountsRequest) {
	request = &DescribeDataCountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeDataCounts", "sddp", "openAPI")
	return
}

// CreateDescribeDataCountsResponse creates a response to parse from DescribeDataCounts response
func CreateDescribeDataCountsResponse() (response *DescribeDataCountsResponse) {
	response = &DescribeDataCountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
