package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindPurchasedDevice invokes the vs.UnbindPurchasedDevice API synchronously
func (client *Client) UnbindPurchasedDevice(request *UnbindPurchasedDeviceRequest) (response *UnbindPurchasedDeviceResponse, err error) {
	response = CreateUnbindPurchasedDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindPurchasedDeviceWithChan invokes the vs.UnbindPurchasedDevice API asynchronously
func (client *Client) UnbindPurchasedDeviceWithChan(request *UnbindPurchasedDeviceRequest) (<-chan *UnbindPurchasedDeviceResponse, <-chan error) {
	responseChan := make(chan *UnbindPurchasedDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindPurchasedDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindPurchasedDeviceWithCallback invokes the vs.UnbindPurchasedDevice API asynchronously
func (client *Client) UnbindPurchasedDeviceWithCallback(request *UnbindPurchasedDeviceRequest, callback func(response *UnbindPurchasedDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindPurchasedDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnbindPurchasedDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindPurchasedDeviceRequest is the request struct for api UnbindPurchasedDevice
type UnbindPurchasedDeviceRequest struct {
	*requests.RpcRequest
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId string           `position:"Query" name:"DeviceId"`
}

// UnbindPurchasedDeviceResponse is the response struct for api UnbindPurchasedDevice
type UnbindPurchasedDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindPurchasedDeviceRequest creates a request to invoke UnbindPurchasedDevice API
func CreateUnbindPurchasedDeviceRequest() (request *UnbindPurchasedDeviceRequest) {
	request = &UnbindPurchasedDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UnbindPurchasedDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindPurchasedDeviceResponse creates a response to parse from UnbindPurchasedDevice response
func CreateUnbindPurchasedDeviceResponse() (response *UnbindPurchasedDeviceResponse) {
	response = &UnbindPurchasedDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
