package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateVpcIpv6Cidr invokes the vpc.AllocateVpcIpv6Cidr API synchronously
func (client *Client) AllocateVpcIpv6Cidr(request *AllocateVpcIpv6CidrRequest) (response *AllocateVpcIpv6CidrResponse, err error) {
	response = CreateAllocateVpcIpv6CidrResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateVpcIpv6CidrWithChan invokes the vpc.AllocateVpcIpv6Cidr API asynchronously
func (client *Client) AllocateVpcIpv6CidrWithChan(request *AllocateVpcIpv6CidrRequest) (<-chan *AllocateVpcIpv6CidrResponse, <-chan error) {
	responseChan := make(chan *AllocateVpcIpv6CidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateVpcIpv6Cidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateVpcIpv6CidrWithCallback invokes the vpc.AllocateVpcIpv6Cidr API asynchronously
func (client *Client) AllocateVpcIpv6CidrWithCallback(request *AllocateVpcIpv6CidrRequest, callback func(response *AllocateVpcIpv6CidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateVpcIpv6CidrResponse
		var err error
		defer close(result)
		response, err = client.AllocateVpcIpv6Cidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateVpcIpv6CidrRequest is the request struct for api AllocateVpcIpv6Cidr
type AllocateVpcIpv6CidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Ipv6Isp              string           `position:"Query" name:"Ipv6Isp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6CidrBlock        string           `position:"Query" name:"Ipv6CidrBlock"`
	AddressPoolType      string           `position:"Query" name:"AddressPoolType"`
}

// AllocateVpcIpv6CidrResponse is the response struct for api AllocateVpcIpv6Cidr
type AllocateVpcIpv6CidrResponse struct {
	*responses.BaseResponse
	Ipv6CidrBlock string `json:"Ipv6CidrBlock" xml:"Ipv6CidrBlock"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateVpcIpv6CidrRequest creates a request to invoke AllocateVpcIpv6Cidr API
func CreateAllocateVpcIpv6CidrRequest() (request *AllocateVpcIpv6CidrRequest) {
	request = &AllocateVpcIpv6CidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AllocateVpcIpv6Cidr", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocateVpcIpv6CidrResponse creates a response to parse from AllocateVpcIpv6Cidr response
func CreateAllocateVpcIpv6CidrResponse() (response *AllocateVpcIpv6CidrResponse) {
	response = &AllocateVpcIpv6CidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
