package threedvision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReconstructThreeDMultiView invokes the threedvision.ReconstructThreeDMultiView API synchronously
func (client *Client) ReconstructThreeDMultiView(request *ReconstructThreeDMultiViewRequest) (response *ReconstructThreeDMultiViewResponse, err error) {
	response = CreateReconstructThreeDMultiViewResponse()
	err = client.DoAction(request, response)
	return
}

// ReconstructThreeDMultiViewWithChan invokes the threedvision.ReconstructThreeDMultiView API asynchronously
func (client *Client) ReconstructThreeDMultiViewWithChan(request *ReconstructThreeDMultiViewRequest) (<-chan *ReconstructThreeDMultiViewResponse, <-chan error) {
	responseChan := make(chan *ReconstructThreeDMultiViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReconstructThreeDMultiView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReconstructThreeDMultiViewWithCallback invokes the threedvision.ReconstructThreeDMultiView API asynchronously
func (client *Client) ReconstructThreeDMultiViewWithCallback(request *ReconstructThreeDMultiViewRequest, callback func(response *ReconstructThreeDMultiViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReconstructThreeDMultiViewResponse
		var err error
		defer close(result)
		response, err = client.ReconstructThreeDMultiView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReconstructThreeDMultiViewRequest is the request struct for api ReconstructThreeDMultiView
type ReconstructThreeDMultiViewRequest struct {
	*requests.RpcRequest
	Mode       string           `position:"Body" name:"Mode"`
	ZipFileUrl string           `position:"Body" name:"ZipFileUrl"`
	Async      requests.Boolean `position:"Body" name:"Async"`
}

// ReconstructThreeDMultiViewResponse is the response struct for api ReconstructThreeDMultiView
type ReconstructThreeDMultiViewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateReconstructThreeDMultiViewRequest creates a request to invoke ReconstructThreeDMultiView API
func CreateReconstructThreeDMultiViewRequest() (request *ReconstructThreeDMultiViewRequest) {
	request = &ReconstructThreeDMultiViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("threedvision", "2021-01-31", "ReconstructThreeDMultiView", "threedvision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReconstructThreeDMultiViewResponse creates a response to parse from ReconstructThreeDMultiView response
func CreateReconstructThreeDMultiViewResponse() (response *ReconstructThreeDMultiViewResponse) {
	response = &ReconstructThreeDMultiViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
