package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSnapshotAttribute invokes the swas_open.UpdateSnapshotAttribute API synchronously
func (client *Client) UpdateSnapshotAttribute(request *UpdateSnapshotAttributeRequest) (response *UpdateSnapshotAttributeResponse, err error) {
	response = CreateUpdateSnapshotAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSnapshotAttributeWithChan invokes the swas_open.UpdateSnapshotAttribute API asynchronously
func (client *Client) UpdateSnapshotAttributeWithChan(request *UpdateSnapshotAttributeRequest) (<-chan *UpdateSnapshotAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateSnapshotAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSnapshotAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSnapshotAttributeWithCallback invokes the swas_open.UpdateSnapshotAttribute API asynchronously
func (client *Client) UpdateSnapshotAttributeWithCallback(request *UpdateSnapshotAttributeRequest, callback func(response *UpdateSnapshotAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSnapshotAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateSnapshotAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSnapshotAttributeRequest is the request struct for api UpdateSnapshotAttribute
type UpdateSnapshotAttributeRequest struct {
	*requests.RpcRequest
	SnapshotId  string `position:"Query" name:"SnapshotId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Remark      string `position:"Query" name:"Remark"`
}

// UpdateSnapshotAttributeResponse is the response struct for api UpdateSnapshotAttribute
type UpdateSnapshotAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSnapshotAttributeRequest creates a request to invoke UpdateSnapshotAttribute API
func CreateUpdateSnapshotAttributeRequest() (request *UpdateSnapshotAttributeRequest) {
	request = &UpdateSnapshotAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "UpdateSnapshotAttribute", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSnapshotAttributeResponse creates a response to parse from UpdateSnapshotAttribute response
func CreateUpdateSnapshotAttributeResponse() (response *UpdateSnapshotAttributeResponse) {
	response = &UpdateSnapshotAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
