package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClientUserDNS invokes the smartag.DescribeClientUserDNS API synchronously
func (client *Client) DescribeClientUserDNS(request *DescribeClientUserDNSRequest) (response *DescribeClientUserDNSResponse, err error) {
	response = CreateDescribeClientUserDNSResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClientUserDNSWithChan invokes the smartag.DescribeClientUserDNS API asynchronously
func (client *Client) DescribeClientUserDNSWithChan(request *DescribeClientUserDNSRequest) (<-chan *DescribeClientUserDNSResponse, <-chan error) {
	responseChan := make(chan *DescribeClientUserDNSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClientUserDNS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClientUserDNSWithCallback invokes the smartag.DescribeClientUserDNS API asynchronously
func (client *Client) DescribeClientUserDNSWithCallback(request *DescribeClientUserDNSRequest, callback func(response *DescribeClientUserDNSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClientUserDNSResponse
		var err error
		defer close(result)
		response, err = client.DescribeClientUserDNS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClientUserDNSRequest is the request struct for api DescribeClientUserDNS
type DescribeClientUserDNSRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeClientUserDNSResponse is the response struct for api DescribeClientUserDNS
type DescribeClientUserDNSResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	AppDNS       []string `json:"AppDNS" xml:"AppDNS"`
	RecoveredDNS []string `json:"RecoveredDNS" xml:"RecoveredDNS"`
}

// CreateDescribeClientUserDNSRequest creates a request to invoke DescribeClientUserDNS API
func CreateDescribeClientUserDNSRequest() (request *DescribeClientUserDNSRequest) {
	request = &DescribeClientUserDNSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeClientUserDNS", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClientUserDNSResponse creates a response to parse from DescribeClientUserDNS response
func CreateDescribeClientUserDNSResponse() (response *DescribeClientUserDNSResponse) {
	response = &DescribeClientUserDNSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
