package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLoadBalancerHTTPSListener invokes the slb.CreateLoadBalancerHTTPSListener API synchronously
func (client *Client) CreateLoadBalancerHTTPSListener(request *CreateLoadBalancerHTTPSListenerRequest) (response *CreateLoadBalancerHTTPSListenerResponse, err error) {
	response = CreateCreateLoadBalancerHTTPSListenerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLoadBalancerHTTPSListenerWithChan invokes the slb.CreateLoadBalancerHTTPSListener API asynchronously
func (client *Client) CreateLoadBalancerHTTPSListenerWithChan(request *CreateLoadBalancerHTTPSListenerRequest) (<-chan *CreateLoadBalancerHTTPSListenerResponse, <-chan error) {
	responseChan := make(chan *CreateLoadBalancerHTTPSListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLoadBalancerHTTPSListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLoadBalancerHTTPSListenerWithCallback invokes the slb.CreateLoadBalancerHTTPSListener API asynchronously
func (client *Client) CreateLoadBalancerHTTPSListenerWithCallback(request *CreateLoadBalancerHTTPSListenerRequest, callback func(response *CreateLoadBalancerHTTPSListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLoadBalancerHTTPSListenerResponse
		var err error
		defer close(result)
		response, err = client.CreateLoadBalancerHTTPSListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLoadBalancerHTTPSListenerRequest is the request struct for api CreateLoadBalancerHTTPSListener
type CreateLoadBalancerHTTPSListenerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                          requests.Integer                                    `position:"Query" name:"ResourceOwnerId"`
	ServerCertificate                        *[]CreateLoadBalancerHTTPSListenerServerCertificate `position:"Query" name:"ServerCertificate"  type:"Repeated"`
	HealthCheckTimeout                       requests.Integer                                    `position:"Query" name:"HealthCheckTimeout"`
	XForwardedFor                            string                                              `position:"Query" name:"XForwardedFor"`
	HealthCheckURI                           string                                              `position:"Query" name:"HealthCheckURI"`
	XForwardedForSLBPORT                     string                                              `position:"Query" name:"XForwardedFor_SLBPORT"`
	AclStatus                                string                                              `position:"Query" name:"AclStatus"`
	AclType                                  string                                              `position:"Query" name:"AclType"`
	HealthCheck                              string                                              `position:"Query" name:"HealthCheck"`
	VpcIds                                   string                                              `position:"Query" name:"VpcIds"`
	Tag                                      *[]CreateLoadBalancerHTTPSListenerTag               `position:"Query" name:"Tag"  type:"Repeated"`
	VServerGroupId                           string                                              `position:"Query" name:"VServerGroupId"`
	AclId                                    string                                              `position:"Query" name:"AclId"`
	XForwardedForClientCertClientVerify      string                                              `position:"Query" name:"XForwardedFor_ClientCertClientVerify"`
	Cookie                                   string                                              `position:"Query" name:"Cookie"`
	HealthCheckMethod                        string                                              `position:"Query" name:"HealthCheckMethod"`
	HealthCheckDomain                        string                                              `position:"Query" name:"HealthCheckDomain"`
	RequestTimeout                           requests.Integer                                    `position:"Query" name:"RequestTimeout"`
	OwnerId                                  requests.Integer                                    `position:"Query" name:"OwnerId"`
	CACertificateId                          string                                              `position:"Query" name:"CACertificateId"`
	BackendProtocol                          string                                              `position:"Query" name:"BackendProtocol"`
	Tags                                     string                                              `position:"Query" name:"Tags"`
	XForwardedForClientCertFingerprintAlias  string                                              `position:"Query" name:"XForwardedFor_ClientCertFingerprintAlias"`
	LoadBalancerId                           string                                              `position:"Query" name:"LoadBalancerId"`
	XForwardedForSLBIP                       string                                              `position:"Query" name:"XForwardedFor_SLBIP"`
	BackendServerPort                        requests.Integer                                    `position:"Query" name:"BackendServerPort"`
	HealthCheckInterval                      requests.Integer                                    `position:"Query" name:"HealthCheckInterval"`
	XForwardedForClientCertClientVerifyAlias string                                              `position:"Query" name:"XForwardedFor_ClientCertClientVerifyAlias"`
	XForwardedForSLBID                       string                                              `position:"Query" name:"XForwardedFor_SLBID"`
	XForwardedForClientCertFingerprint       string                                              `position:"Query" name:"XForwardedFor_ClientCertFingerprint"`
	HealthCheckHttpVersion                   string                                              `position:"Query" name:"HealthCheckHttpVersion"`
	AccessKeyId                              string                                              `position:"Query" name:"access_key_id"`
	XForwardedForClientSrcPort               string                                              `position:"Query" name:"XForwardedFor_ClientSrcPort"`
	Description                              string                                              `position:"Query" name:"Description"`
	UnhealthyThreshold                       requests.Integer                                    `position:"Query" name:"UnhealthyThreshold"`
	XForwardedForClientCertIssuerDNAlias     string                                              `position:"Query" name:"XForwardedFor_ClientCertIssuerDNAlias"`
	HealthyThreshold                         requests.Integer                                    `position:"Query" name:"HealthyThreshold"`
	Scheduler                                string                                              `position:"Query" name:"Scheduler"`
	MaxConnection                            requests.Integer                                    `position:"Query" name:"MaxConnection"`
	EnableHttp2                              string                                              `position:"Query" name:"EnableHttp2"`
	XForwardedForClientCertSubjectDN         string                                              `position:"Query" name:"XForwardedFor_ClientCertSubjectDN"`
	CookieTimeout                            requests.Integer                                    `position:"Query" name:"CookieTimeout"`
	StickySessionType                        string                                              `position:"Query" name:"StickySessionType"`
	ListenerPort                             requests.Integer                                    `position:"Query" name:"ListenerPort"`
	HealthCheckType                          string                                              `position:"Query" name:"HealthCheckType"`
	ResourceOwnerAccount                     string                                              `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth                                requests.Integer                                    `position:"Query" name:"Bandwidth"`
	StickySession                            string                                              `position:"Query" name:"StickySession"`
	OwnerAccount                             string                                              `position:"Query" name:"OwnerAccount"`
	Gzip                                     string                                              `position:"Query" name:"Gzip"`
	TLSCipherPolicy                          string                                              `position:"Query" name:"TLSCipherPolicy"`
	ServerCertificateId                      string                                              `position:"Query" name:"ServerCertificateId"`
	IdleTimeout                              requests.Integer                                    `position:"Query" name:"IdleTimeout"`
	XForwardedForProto                       string                                              `position:"Query" name:"XForwardedFor_proto"`
	XForwardedForClientCertSubjectDNAlias    string                                              `position:"Query" name:"XForwardedFor_ClientCertSubjectDNAlias"`
	HealthCheckConnectPort                   requests.Integer                                    `position:"Query" name:"HealthCheckConnectPort"`
	HealthCheckHttpCode                      string                                              `position:"Query" name:"HealthCheckHttpCode"`
	XForwardedForClientCertIssuerDN          string                                              `position:"Query" name:"XForwardedFor_ClientCertIssuerDN"`
}

// CreateLoadBalancerHTTPSListenerServerCertificate is a repeated param struct in CreateLoadBalancerHTTPSListenerRequest
type CreateLoadBalancerHTTPSListenerServerCertificate struct {
	BindingType   string `name:"BindingType"`
	CertificateId string `name:"CertificateId"`
	StandardType  string `name:"StandardType"`
}

// CreateLoadBalancerHTTPSListenerTag is a repeated param struct in CreateLoadBalancerHTTPSListenerRequest
type CreateLoadBalancerHTTPSListenerTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateLoadBalancerHTTPSListenerResponse is the response struct for api CreateLoadBalancerHTTPSListener
type CreateLoadBalancerHTTPSListenerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLoadBalancerHTTPSListenerRequest creates a request to invoke CreateLoadBalancerHTTPSListener API
func CreateCreateLoadBalancerHTTPSListenerRequest() (request *CreateLoadBalancerHTTPSListenerRequest) {
	request = &CreateLoadBalancerHTTPSListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "CreateLoadBalancerHTTPSListener", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLoadBalancerHTTPSListenerResponse creates a response to parse from CreateLoadBalancerHTTPSListener response
func CreateCreateLoadBalancerHTTPSListenerResponse() (response *CreateLoadBalancerHTTPSListenerResponse) {
	response = &CreateLoadBalancerHTTPSListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
