package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayBlockVolume invokes the sgw.CreateGatewayBlockVolume API synchronously
func (client *Client) CreateGatewayBlockVolume(request *CreateGatewayBlockVolumeRequest) (response *CreateGatewayBlockVolumeResponse, err error) {
	response = CreateCreateGatewayBlockVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayBlockVolumeWithChan invokes the sgw.CreateGatewayBlockVolume API asynchronously
func (client *Client) CreateGatewayBlockVolumeWithChan(request *CreateGatewayBlockVolumeRequest) (<-chan *CreateGatewayBlockVolumeResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayBlockVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayBlockVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayBlockVolumeWithCallback invokes the sgw.CreateGatewayBlockVolume API asynchronously
func (client *Client) CreateGatewayBlockVolumeWithCallback(request *CreateGatewayBlockVolumeRequest, callback func(response *CreateGatewayBlockVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayBlockVolumeResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayBlockVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayBlockVolumeRequest is the request struct for api CreateGatewayBlockVolume
type CreateGatewayBlockVolumeRequest struct {
	*requests.RpcRequest
	OssEndpoint    string           `position:"Query" name:"OssEndpoint"`
	Recovery       requests.Boolean `position:"Query" name:"Recovery"`
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
	ChunkSize      requests.Integer `position:"Query" name:"ChunkSize"`
	GatewayId      string           `position:"Query" name:"GatewayId"`
	VolumeProtocol string           `position:"Query" name:"VolumeProtocol"`
	ChapEnabled    requests.Boolean `position:"Query" name:"ChapEnabled"`
	CacheMode      string           `position:"Query" name:"CacheMode"`
	LocalFilePath  string           `position:"Query" name:"LocalFilePath"`
	OssBucketSsl   requests.Boolean `position:"Query" name:"OssBucketSsl"`
	Size           requests.Integer `position:"Query" name:"Size"`
	ChapInUser     string           `position:"Query" name:"ChapInUser"`
	Name           string           `position:"Query" name:"Name"`
	OssBucketName  string           `position:"Query" name:"OssBucketName"`
	ChapInPassword string           `position:"Query" name:"ChapInPassword"`
}

// CreateGatewayBlockVolumeResponse is the response struct for api CreateGatewayBlockVolume
type CreateGatewayBlockVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateGatewayBlockVolumeRequest creates a request to invoke CreateGatewayBlockVolume API
func CreateCreateGatewayBlockVolumeRequest() (request *CreateGatewayBlockVolumeRequest) {
	request = &CreateGatewayBlockVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateGatewayBlockVolume", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayBlockVolumeResponse creates a response to parse from CreateGatewayBlockVolume response
func CreateCreateGatewayBlockVolumeResponse() (response *CreateGatewayBlockVolumeResponse) {
	response = &CreateGatewayBlockVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
