package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopMaskingProcess invokes the sddp.StopMaskingProcess API synchronously
func (client *Client) StopMaskingProcess(request *StopMaskingProcessRequest) (response *StopMaskingProcessResponse, err error) {
	response = CreateStopMaskingProcessResponse()
	err = client.DoAction(request, response)
	return
}

// StopMaskingProcessWithChan invokes the sddp.StopMaskingProcess API asynchronously
func (client *Client) StopMaskingProcessWithChan(request *StopMaskingProcessRequest) (<-chan *StopMaskingProcessResponse, <-chan error) {
	responseChan := make(chan *StopMaskingProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopMaskingProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopMaskingProcessWithCallback invokes the sddp.StopMaskingProcess API asynchronously
func (client *Client) StopMaskingProcessWithCallback(request *StopMaskingProcessRequest, callback func(response *StopMaskingProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopMaskingProcessResponse
		var err error
		defer close(result)
		response, err = client.StopMaskingProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopMaskingProcessRequest is the request struct for api StopMaskingProcess
type StopMaskingProcessRequest struct {
	*requests.RpcRequest
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Id          requests.Integer `position:"Query" name:"Id"`
	Lang        string           `position:"Query" name:"Lang"`
}

// StopMaskingProcessResponse is the response struct for api StopMaskingProcess
type StopMaskingProcessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopMaskingProcessRequest creates a request to invoke StopMaskingProcess API
func CreateStopMaskingProcessRequest() (request *StopMaskingProcessRequest) {
	request = &StopMaskingProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "StopMaskingProcess", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopMaskingProcessResponse creates a response to parse from StopMaskingProcess response
func CreateStopMaskingProcessResponse() (response *StopMaskingProcessResponse) {
	response = &StopMaskingProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
