package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryChangeInfo invokes the safe.QueryChangeInfo API synchronously
func (client *Client) QueryChangeInfo(request *QueryChangeInfoRequest) (response *QueryChangeInfoResponse, err error) {
	response = CreateQueryChangeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryChangeInfoWithChan invokes the safe.QueryChangeInfo API asynchronously
func (client *Client) QueryChangeInfoWithChan(request *QueryChangeInfoRequest) (<-chan *QueryChangeInfoResponse, <-chan error) {
	responseChan := make(chan *QueryChangeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryChangeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryChangeInfoWithCallback invokes the safe.QueryChangeInfo API asynchronously
func (client *Client) QueryChangeInfoWithCallback(request *QueryChangeInfoRequest, callback func(response *QueryChangeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryChangeInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryChangeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryChangeInfoRequest is the request struct for api QueryChangeInfo
type QueryChangeInfoRequest struct {
	*requests.RpcRequest
	BuId          string                   `position:"Body" name:"BuId"`
	AuthKey       string                   `position:"Body" name:"AuthKey"`
	Product       *[]string                `position:"Body" name:"Product"  type:"Repeated"`
	EndTime       requests.Integer         `position:"Body" name:"EndTime"`
	AuthSign      string                   `position:"Body" name:"AuthSign"`
	Source        string                   `position:"Body" name:"Source"`
	StartTime     requests.Integer         `position:"Body" name:"StartTime"`
	Type          string                   `position:"Query" name:"Type"`
	ReqTimestamp  requests.Integer         `position:"Body" name:"ReqTimestamp"`
	LevelTree     QueryChangeInfoLevelTree `position:"Body" name:"LevelTree"  type:"Struct"`
	Limit         requests.Integer         `position:"Body" name:"Limit"`
	SourceOrderId string                   `position:"Body" name:"SourceOrderId"`
	BgVid         string                   `position:"Body" name:"BgVid"`
	Az            *[]string                `position:"Body" name:"Az"  type:"Repeated"`
	Page          requests.Integer         `position:"Body" name:"Page"`
	Keyword       string                   `position:"Body" name:"Keyword"`
	Region        *[]string                `position:"Body" name:"Region"  type:"Repeated"`
	ChangeSystem  string                   `position:"Body" name:"ChangeSystem"`
}

// QueryChangeInfoLevelTree is a repeated param struct in QueryChangeInfoRequest
type QueryChangeInfoLevelTree struct {
	DataType string                                  `name:"DataType"`
	TreeData *[]QueryChangeInfoLevelTreeTreeDataItem `name:"TreeData" type:"Repeated"`
}

// QueryChangeInfoLevelTreeTreeDataItem is a repeated param struct in QueryChangeInfoRequest
type QueryChangeInfoLevelTreeTreeDataItem struct {
	Data        *[]string `name:"Data" type:"Repeated"`
	Value       *[]string `name:"Value" type:"Repeated"`
	DataSubType string    `name:"DataSubType"`
}

// QueryChangeInfoResponse is the response struct for api QueryChangeInfo
type QueryChangeInfoResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryChangeInfoRequest creates a request to invoke QueryChangeInfo API
func CreateQueryChangeInfoRequest() (request *QueryChangeInfoRequest) {
	request = &QueryChangeInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryChangeInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryChangeInfoResponse creates a response to parse from QueryChangeInfo response
func CreateQueryChangeInfoResponse() (response *QueryChangeInfoResponse) {
	response = &QueryChangeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
