package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResources invokes the resourcemanager.ListResources API synchronously
func (client *Client) ListResources(request *ListResourcesRequest) (response *ListResourcesResponse, err error) {
	response = CreateListResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourcesWithChan invokes the resourcemanager.ListResources API asynchronously
func (client *Client) ListResourcesWithChan(request *ListResourcesRequest) (<-chan *ListResourcesResponse, <-chan error) {
	responseChan := make(chan *ListResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourcesWithCallback invokes the resourcemanager.ListResources API asynchronously
func (client *Client) ListResourcesWithCallback(request *ListResourcesRequest, callback func(response *ListResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourcesRequest is the request struct for api ListResources
type ListResourcesRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer              `position:"Query" name:"PageNumber"`
	ResourceGroupId string                        `position:"Query" name:"ResourceGroupId"`
	PageSize        requests.Integer              `position:"Query" name:"PageSize"`
	ResourceId      string                        `position:"Query" name:"ResourceId"`
	ResourceTypes   *[]ListResourcesResourceTypes `position:"Query" name:"ResourceTypes"  type:"Repeated"`
	ResourceType    string                        `position:"Query" name:"ResourceType"`
	Service         string                        `position:"Query" name:"Service"`
	Region          string                        `position:"Query" name:"Region"`
	ResourceIds     string                        `position:"Query" name:"ResourceIds"`
}

// ListResourcesResourceTypes is a repeated param struct in ListResourcesRequest
type ListResourcesResourceTypes struct {
	Service      string `name:"Service"`
	ResourceType string `name:"ResourceType"`
}

// ListResourcesResponse is the response struct for api ListResources
type ListResourcesResponse struct {
	*responses.BaseResponse
	TotalCount int                      `json:"TotalCount" xml:"TotalCount"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	Resources  ResourcesInListResources `json:"Resources" xml:"Resources"`
}

// CreateListResourcesRequest creates a request to invoke ListResources API
func CreateListResourcesRequest() (request *ListResourcesRequest) {
	request = &ListResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListResources", "", "")
	request.Method = requests.POST
	return
}

// CreateListResourcesResponse creates a response to parse from ListResources response
func CreateListResourcesResponse() (response *ListResourcesResponse) {
	response = &ListResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
