package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableMultiAccountResourceCenter invokes the resourcecenter.EnableMultiAccountResourceCenter API synchronously
func (client *Client) EnableMultiAccountResourceCenter(request *EnableMultiAccountResourceCenterRequest) (response *EnableMultiAccountResourceCenterResponse, err error) {
	response = CreateEnableMultiAccountResourceCenterResponse()
	err = client.DoAction(request, response)
	return
}

// EnableMultiAccountResourceCenterWithChan invokes the resourcecenter.EnableMultiAccountResourceCenter API asynchronously
func (client *Client) EnableMultiAccountResourceCenterWithChan(request *EnableMultiAccountResourceCenterRequest) (<-chan *EnableMultiAccountResourceCenterResponse, <-chan error) {
	responseChan := make(chan *EnableMultiAccountResourceCenterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableMultiAccountResourceCenter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableMultiAccountResourceCenterWithCallback invokes the resourcecenter.EnableMultiAccountResourceCenter API asynchronously
func (client *Client) EnableMultiAccountResourceCenterWithCallback(request *EnableMultiAccountResourceCenterRequest, callback func(response *EnableMultiAccountResourceCenterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableMultiAccountResourceCenterResponse
		var err error
		defer close(result)
		response, err = client.EnableMultiAccountResourceCenter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableMultiAccountResourceCenterRequest is the request struct for api EnableMultiAccountResourceCenter
type EnableMultiAccountResourceCenterRequest struct {
	*requests.RpcRequest
	Channel string `position:"Query" name:"Channel"`
}

// EnableMultiAccountResourceCenterResponse is the response struct for api EnableMultiAccountResourceCenter
type EnableMultiAccountResourceCenterResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableMultiAccountResourceCenterRequest creates a request to invoke EnableMultiAccountResourceCenter API
func CreateEnableMultiAccountResourceCenterRequest() (request *EnableMultiAccountResourceCenterRequest) {
	request = &EnableMultiAccountResourceCenterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "EnableMultiAccountResourceCenter", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableMultiAccountResourceCenterResponse creates a response to parse from EnableMultiAccountResourceCenter response
func CreateEnableMultiAccountResourceCenterResponse() (response *EnableMultiAccountResourceCenterResponse) {
	response = &EnableMultiAccountResourceCenterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
