package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDatasetSmartqStatus invokes the quickbi_public.QueryDatasetSmartqStatus API synchronously
func (client *Client) QueryDatasetSmartqStatus(request *QueryDatasetSmartqStatusRequest) (response *QueryDatasetSmartqStatusResponse, err error) {
	response = CreateQueryDatasetSmartqStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDatasetSmartqStatusWithChan invokes the quickbi_public.QueryDatasetSmartqStatus API asynchronously
func (client *Client) QueryDatasetSmartqStatusWithChan(request *QueryDatasetSmartqStatusRequest) (<-chan *QueryDatasetSmartqStatusResponse, <-chan error) {
	responseChan := make(chan *QueryDatasetSmartqStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDatasetSmartqStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDatasetSmartqStatusWithCallback invokes the quickbi_public.QueryDatasetSmartqStatus API asynchronously
func (client *Client) QueryDatasetSmartqStatusWithCallback(request *QueryDatasetSmartqStatusRequest, callback func(response *QueryDatasetSmartqStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDatasetSmartqStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryDatasetSmartqStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDatasetSmartqStatusRequest is the request struct for api QueryDatasetSmartqStatus
type QueryDatasetSmartqStatusRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	CubeId      string `position:"Query" name:"CubeId"`
}

// QueryDatasetSmartqStatusResponse is the response struct for api QueryDatasetSmartqStatus
type QueryDatasetSmartqStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryDatasetSmartqStatusRequest creates a request to invoke QueryDatasetSmartqStatus API
func CreateQueryDatasetSmartqStatusRequest() (request *QueryDatasetSmartqStatusRequest) {
	request = &QueryDatasetSmartqStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryDatasetSmartqStatus", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDatasetSmartqStatusResponse creates a response to parse from QueryDatasetSmartqStatus response
func CreateQueryDatasetSmartqStatusResponse() (response *QueryDatasetSmartqStatusResponse) {
	response = &QueryDatasetSmartqStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
