package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSchemeTaskConfig invokes the qualitycheck.ListSchemeTaskConfig API synchronously
func (client *Client) ListSchemeTaskConfig(request *ListSchemeTaskConfigRequest) (response *ListSchemeTaskConfigResponse, err error) {
	response = CreateListSchemeTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListSchemeTaskConfigWithChan invokes the qualitycheck.ListSchemeTaskConfig API asynchronously
func (client *Client) ListSchemeTaskConfigWithChan(request *ListSchemeTaskConfigRequest) (<-chan *ListSchemeTaskConfigResponse, <-chan error) {
	responseChan := make(chan *ListSchemeTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSchemeTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSchemeTaskConfigWithCallback invokes the qualitycheck.ListSchemeTaskConfig API asynchronously
func (client *Client) ListSchemeTaskConfigWithCallback(request *ListSchemeTaskConfigRequest, callback func(response *ListSchemeTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSchemeTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.ListSchemeTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSchemeTaskConfigRequest is the request struct for api ListSchemeTaskConfig
type ListSchemeTaskConfigRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// ListSchemeTaskConfigResponse is the response struct for api ListSchemeTaskConfig
type ListSchemeTaskConfigResponse struct {
	*responses.BaseResponse
	Count          int                            `json:"Count" xml:"Count"`
	CurrentPage    int                            `json:"CurrentPage" xml:"CurrentPage"`
	PageSize       int                            `json:"PageSize" xml:"PageSize"`
	PageNumber     int                            `json:"PageNumber" xml:"PageNumber"`
	ResultCountId  string                         `json:"ResultCountId" xml:"ResultCountId"`
	LastDataId     string                         `json:"LastDataId" xml:"LastDataId"`
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	Success        bool                           `json:"Success" xml:"Success"`
	Code           string                         `json:"Code" xml:"Code"`
	Message        string                         `json:"Message" xml:"Message"`
	HttpStatusCode int                            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInListSchemeTaskConfig `json:"Messages" xml:"Messages"`
	Data           DataInListSchemeTaskConfig     `json:"Data" xml:"Data"`
}

// CreateListSchemeTaskConfigRequest creates a request to invoke ListSchemeTaskConfig API
func CreateListSchemeTaskConfigRequest() (request *ListSchemeTaskConfigRequest) {
	request = &ListSchemeTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListSchemeTaskConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateListSchemeTaskConfigResponse creates a response to parse from ListSchemeTaskConfig response
func CreateListSchemeTaskConfigResponse() (response *ListSchemeTaskConfigResponse) {
	response = &ListSchemeTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
