package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRuleV4 invokes the qualitycheck.DeleteRuleV4 API synchronously
func (client *Client) DeleteRuleV4(request *DeleteRuleV4Request) (response *DeleteRuleV4Response, err error) {
	response = CreateDeleteRuleV4Response()
	err = client.DoAction(request, response)
	return
}

// DeleteRuleV4WithChan invokes the qualitycheck.DeleteRuleV4 API asynchronously
func (client *Client) DeleteRuleV4WithChan(request *DeleteRuleV4Request) (<-chan *DeleteRuleV4Response, <-chan error) {
	responseChan := make(chan *DeleteRuleV4Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRuleV4(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRuleV4WithCallback invokes the qualitycheck.DeleteRuleV4 API asynchronously
func (client *Client) DeleteRuleV4WithCallback(request *DeleteRuleV4Request, callback func(response *DeleteRuleV4Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRuleV4Response
		var err error
		defer close(result)
		response, err = client.DeleteRuleV4(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRuleV4Request is the request struct for api DeleteRuleV4
type DeleteRuleV4Request struct {
	*requests.RpcRequest
	IsSchemeData  requests.Integer `position:"Body" name:"IsSchemeData"`
	ForceDelete   requests.Boolean `position:"Body" name:"ForceDelete"`
	RuleId        requests.Integer `position:"Body" name:"RuleId"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// DeleteRuleV4Response is the response struct for api DeleteRuleV4
type DeleteRuleV4Response struct {
	*responses.BaseResponse
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	Success        bool                   `json:"Success" xml:"Success"`
	Code           string                 `json:"Code" xml:"Code"`
	Message        string                 `json:"Message" xml:"Message"`
	HttpStatusCode int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInDeleteRuleV4 `json:"Messages" xml:"Messages"`
}

// CreateDeleteRuleV4Request creates a request to invoke DeleteRuleV4 API
func CreateDeleteRuleV4Request() (request *DeleteRuleV4Request) {
	request = &DeleteRuleV4Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteRuleV4", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRuleV4Response creates a response to parse from DeleteRuleV4 response
func CreateDeleteRuleV4Response() (response *DeleteRuleV4Response) {
	response = &DeleteRuleV4Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
