package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteQualityCheckScheme invokes the qualitycheck.DeleteQualityCheckScheme API synchronously
func (client *Client) DeleteQualityCheckScheme(request *DeleteQualityCheckSchemeRequest) (response *DeleteQualityCheckSchemeResponse, err error) {
	response = CreateDeleteQualityCheckSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteQualityCheckSchemeWithChan invokes the qualitycheck.DeleteQualityCheckScheme API asynchronously
func (client *Client) DeleteQualityCheckSchemeWithChan(request *DeleteQualityCheckSchemeRequest) (<-chan *DeleteQualityCheckSchemeResponse, <-chan error) {
	responseChan := make(chan *DeleteQualityCheckSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteQualityCheckScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteQualityCheckSchemeWithCallback invokes the qualitycheck.DeleteQualityCheckScheme API asynchronously
func (client *Client) DeleteQualityCheckSchemeWithCallback(request *DeleteQualityCheckSchemeRequest, callback func(response *DeleteQualityCheckSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteQualityCheckSchemeResponse
		var err error
		defer close(result)
		response, err = client.DeleteQualityCheckScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteQualityCheckSchemeRequest is the request struct for api DeleteQualityCheckScheme
type DeleteQualityCheckSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// DeleteQualityCheckSchemeResponse is the response struct for api DeleteQualityCheckScheme
type DeleteQualityCheckSchemeResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	Success        bool                               `json:"Success" xml:"Success"`
	Code           string                             `json:"Code" xml:"Code"`
	Message        string                             `json:"Message" xml:"Message"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInDeleteQualityCheckScheme `json:"Messages" xml:"Messages"`
}

// CreateDeleteQualityCheckSchemeRequest creates a request to invoke DeleteQualityCheckScheme API
func CreateDeleteQualityCheckSchemeRequest() (request *DeleteQualityCheckSchemeRequest) {
	request = &DeleteQualityCheckSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "DeleteQualityCheckScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteQualityCheckSchemeResponse creates a response to parse from DeleteQualityCheckScheme response
func CreateDeleteQualityCheckSchemeResponse() (response *DeleteQualityCheckSchemeResponse) {
	response = &DeleteQualityCheckSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
