package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDiagnosis invokes the qianzhou.CreateDiagnosis API synchronously
func (client *Client) CreateDiagnosis(request *CreateDiagnosisRequest) (response *CreateDiagnosisResponse, err error) {
	response = CreateCreateDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDiagnosisWithChan invokes the qianzhou.CreateDiagnosis API asynchronously
func (client *Client) CreateDiagnosisWithChan(request *CreateDiagnosisRequest) (<-chan *CreateDiagnosisResponse, <-chan error) {
	responseChan := make(chan *CreateDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDiagnosisWithCallback invokes the qianzhou.CreateDiagnosis API asynchronously
func (client *Client) CreateDiagnosisWithCallback(request *CreateDiagnosisRequest, callback func(response *CreateDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.CreateDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDiagnosisRequest is the request struct for api CreateDiagnosis
type CreateDiagnosisRequest struct {
	*requests.RoaRequest
	DiagnosisType string `position:"Query" name:"diagnosisType"`
	ClusterID     string `position:"Query" name:"clusterID"`
	Body          string `position:"Body" name:"body"`
}

// CreateDiagnosisResponse is the response struct for api CreateDiagnosis
type CreateDiagnosisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      int64  `json:"code" xml:"code"`
	Data      string `json:"data" xml:"data"`
}

// CreateCreateDiagnosisRequest creates a request to invoke CreateDiagnosis API
func CreateCreateDiagnosisRequest() (request *CreateDiagnosisRequest) {
	request = &CreateDiagnosisRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "CreateDiagnosis", "/popapi/createDiagnosis", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDiagnosisResponse creates a response to parse from CreateDiagnosis response
func CreateCreateDiagnosisResponse() (response *CreateDiagnosisResponse) {
	response = &CreateDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
