package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenPrivateLinkService invokes the privatelink.OpenPrivateLinkService API synchronously
func (client *Client) OpenPrivateLinkService(request *OpenPrivateLinkServiceRequest) (response *OpenPrivateLinkServiceResponse, err error) {
	response = CreateOpenPrivateLinkServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenPrivateLinkServiceWithChan invokes the privatelink.OpenPrivateLinkService API asynchronously
func (client *Client) OpenPrivateLinkServiceWithChan(request *OpenPrivateLinkServiceRequest) (<-chan *OpenPrivateLinkServiceResponse, <-chan error) {
	responseChan := make(chan *OpenPrivateLinkServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenPrivateLinkService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenPrivateLinkServiceWithCallback invokes the privatelink.OpenPrivateLinkService API asynchronously
func (client *Client) OpenPrivateLinkServiceWithCallback(request *OpenPrivateLinkServiceRequest, callback func(response *OpenPrivateLinkServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenPrivateLinkServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenPrivateLinkService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenPrivateLinkServiceRequest is the request struct for api OpenPrivateLinkService
type OpenPrivateLinkServiceRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenPrivateLinkServiceResponse is the response struct for api OpenPrivateLinkService
type OpenPrivateLinkServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenPrivateLinkServiceRequest creates a request to invoke OpenPrivateLinkService API
func CreateOpenPrivateLinkServiceRequest() (request *OpenPrivateLinkServiceRequest) {
	request = &OpenPrivateLinkServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "OpenPrivateLinkService", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenPrivateLinkServiceResponse creates a response to parse from OpenPrivateLinkService response
func CreateOpenPrivateLinkServiceResponse() (response *OpenPrivateLinkServiceResponse) {
	response = &OpenPrivateLinkServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
