package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProjectFeatureEntity invokes the paifeaturestore.GetProjectFeatureEntity API synchronously
func (client *Client) GetProjectFeatureEntity(request *GetProjectFeatureEntityRequest) (response *GetProjectFeatureEntityResponse, err error) {
	response = CreateGetProjectFeatureEntityResponse()
	err = client.DoAction(request, response)
	return
}

// GetProjectFeatureEntityWithChan invokes the paifeaturestore.GetProjectFeatureEntity API asynchronously
func (client *Client) GetProjectFeatureEntityWithChan(request *GetProjectFeatureEntityRequest) (<-chan *GetProjectFeatureEntityResponse, <-chan error) {
	responseChan := make(chan *GetProjectFeatureEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProjectFeatureEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProjectFeatureEntityWithCallback invokes the paifeaturestore.GetProjectFeatureEntity API asynchronously
func (client *Client) GetProjectFeatureEntityWithCallback(request *GetProjectFeatureEntityRequest, callback func(response *GetProjectFeatureEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProjectFeatureEntityResponse
		var err error
		defer close(result)
		response, err = client.GetProjectFeatureEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProjectFeatureEntityRequest is the request struct for api GetProjectFeatureEntity
type GetProjectFeatureEntityRequest struct {
	*requests.RoaRequest
	InstanceId        string `position:"Path" name:"InstanceId"`
	FeatureEntityName string `position:"Path" name:"FeatureEntityName"`
	ProjectId         string `position:"Path" name:"ProjectId"`
}

// GetProjectFeatureEntityResponse is the response struct for api GetProjectFeatureEntity
type GetProjectFeatureEntityResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Name            string `json:"Name" xml:"Name"`
	FeatureEntityId string `json:"FeatureEntityId" xml:"FeatureEntityId"`
	ProjectName     string `json:"ProjectName" xml:"ProjectName"`
	WorkspaceId     string `json:"WorkspaceId" xml:"WorkspaceId"`
	JoinId          string `json:"JoinId" xml:"JoinId"`
}

// CreateGetProjectFeatureEntityRequest creates a request to invoke GetProjectFeatureEntity API
func CreateGetProjectFeatureEntityRequest() (request *GetProjectFeatureEntityRequest) {
	request = &GetProjectFeatureEntityRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetProjectFeatureEntity", "/api/v1/instances/[InstanceId]/projects/[ProjectId]/featureentities/[FeatureEntityName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetProjectFeatureEntityResponse creates a response to parse from GetProjectFeatureEntity response
func CreateGetProjectFeatureEntityResponse() (response *GetProjectFeatureEntityResponse) {
	response = &GetProjectFeatureEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
