package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFeatureEntity invokes the paifeaturestore.GetFeatureEntity API synchronously
func (client *Client) GetFeatureEntity(request *GetFeatureEntityRequest) (response *GetFeatureEntityResponse, err error) {
	response = CreateGetFeatureEntityResponse()
	err = client.DoAction(request, response)
	return
}

// GetFeatureEntityWithChan invokes the paifeaturestore.GetFeatureEntity API asynchronously
func (client *Client) GetFeatureEntityWithChan(request *GetFeatureEntityRequest) (<-chan *GetFeatureEntityResponse, <-chan error) {
	responseChan := make(chan *GetFeatureEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFeatureEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFeatureEntityWithCallback invokes the paifeaturestore.GetFeatureEntity API asynchronously
func (client *Client) GetFeatureEntityWithCallback(request *GetFeatureEntityRequest, callback func(response *GetFeatureEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFeatureEntityResponse
		var err error
		defer close(result)
		response, err = client.GetFeatureEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFeatureEntityRequest is the request struct for api GetFeatureEntity
type GetFeatureEntityRequest struct {
	*requests.RoaRequest
	FeatureEntityId string `position:"Path" name:"FeatureEntityId"`
	InstanceId      string `position:"Path" name:"InstanceId"`
}

// GetFeatureEntityResponse is the response struct for api GetFeatureEntity
type GetFeatureEntityResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Name          string `json:"Name" xml:"Name"`
	ProjectId     string `json:"ProjectId" xml:"ProjectId"`
	ProjectName   string `json:"ProjectName" xml:"ProjectName"`
	JoinId        string `json:"JoinId" xml:"JoinId"`
	Owner         string `json:"Owner" xml:"Owner"`
	GmtCreateTime string `json:"GmtCreateTime" xml:"GmtCreateTime"`
}

// CreateGetFeatureEntityRequest creates a request to invoke GetFeatureEntity API
func CreateGetFeatureEntityRequest() (request *GetFeatureEntityRequest) {
	request = &GetFeatureEntityRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetFeatureEntity", "/api/v1/instances/[InstanceId]/featureentities/[FeatureEntityId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFeatureEntityResponse creates a response to parse from GetFeatureEntity response
func CreateGetFeatureEntityResponse() (response *GetFeatureEntityResponse) {
	response = &GetFeatureEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
