package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateUploadUrl invokes the outboundbot.GenerateUploadUrl API synchronously
func (client *Client) GenerateUploadUrl(request *GenerateUploadUrlRequest) (response *GenerateUploadUrlResponse, err error) {
	response = CreateGenerateUploadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateUploadUrlWithChan invokes the outboundbot.GenerateUploadUrl API asynchronously
func (client *Client) GenerateUploadUrlWithChan(request *GenerateUploadUrlRequest) (<-chan *GenerateUploadUrlResponse, <-chan error) {
	responseChan := make(chan *GenerateUploadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateUploadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateUploadUrlWithCallback invokes the outboundbot.GenerateUploadUrl API asynchronously
func (client *Client) GenerateUploadUrlWithCallback(request *GenerateUploadUrlRequest, callback func(response *GenerateUploadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateUploadUrlResponse
		var err error
		defer close(result)
		response, err = client.GenerateUploadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateUploadUrlRequest is the request struct for api GenerateUploadUrl
type GenerateUploadUrlRequest struct {
	*requests.RpcRequest
	FileName string `position:"Query" name:"FileName"`
	Key      string `position:"Query" name:"Key"`
}

// GenerateUploadUrlResponse is the response struct for api GenerateUploadUrl
type GenerateUploadUrlResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGenerateUploadUrlRequest creates a request to invoke GenerateUploadUrl API
func CreateGenerateUploadUrlRequest() (request *GenerateUploadUrlRequest) {
	request = &GenerateUploadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GenerateUploadUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateUploadUrlResponse creates a response to parse from GenerateUploadUrl response
func CreateGenerateUploadUrlResponse() (response *GenerateUploadUrlResponse) {
	response = &GenerateUploadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
