package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlowSQLList invokes the oceanbasepro.DescribeSlowSQLList API synchronously
func (client *Client) DescribeSlowSQLList(request *DescribeSlowSQLListRequest) (response *DescribeSlowSQLListResponse, err error) {
	response = CreateDescribeSlowSQLListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlowSQLListWithChan invokes the oceanbasepro.DescribeSlowSQLList API asynchronously
func (client *Client) DescribeSlowSQLListWithChan(request *DescribeSlowSQLListRequest) (<-chan *DescribeSlowSQLListResponse, <-chan error) {
	responseChan := make(chan *DescribeSlowSQLListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlowSQLList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlowSQLListWithCallback invokes the oceanbasepro.DescribeSlowSQLList API asynchronously
func (client *Client) DescribeSlowSQLListWithCallback(request *DescribeSlowSQLListRequest, callback func(response *DescribeSlowSQLListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlowSQLListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlowSQLList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlowSQLListRequest is the request struct for api DescribeSlowSQLList
type DescribeSlowSQLListRequest struct {
	*requests.RpcRequest
	StartTime       string           `position:"Body" name:"StartTime"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	SearchRule      string           `position:"Body" name:"SearchRule"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	SearchParameter string           `position:"Body" name:"SearchParameter"`
	SortOrder       string           `position:"Body" name:"SortOrder"`
	SearchValue     string           `position:"Body" name:"SearchValue"`
	SQLId           string           `position:"Body" name:"SQLId"`
	FilterCondition string           `position:"Body" name:"FilterCondition"`
	EndTime         string           `position:"Body" name:"EndTime"`
	NodeIp          string           `position:"Body" name:"NodeIp"`
	DbName          string           `position:"Body" name:"DbName"`
	SearchKeyWord   string           `position:"Body" name:"SearchKeyWord"`
	SortColumn      string           `position:"Body" name:"SortColumn"`
}

// DescribeSlowSQLListResponse is the response struct for api DescribeSlowSQLList
type DescribeSlowSQLListResponse struct {
	*responses.BaseResponse
	TotalCount  int64  `json:"TotalCount" xml:"TotalCount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	SlowSQLList []Data `json:"SlowSQLList" xml:"SlowSQLList"`
}

// CreateDescribeSlowSQLListRequest creates a request to invoke DescribeSlowSQLList API
func CreateDescribeSlowSQLListRequest() (request *DescribeSlowSQLListRequest) {
	request = &DescribeSlowSQLListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSlowSQLList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSlowSQLListResponse creates a response to parse from DescribeSlowSQLList response
func CreateDescribeSlowSQLListResponse() (response *DescribeSlowSQLListResponse) {
	response = &DescribeSlowSQLListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
