package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLabel invokes the oceanbasepro.CreateLabel API synchronously
func (client *Client) CreateLabel(request *CreateLabelRequest) (response *CreateLabelResponse, err error) {
	response = CreateCreateLabelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLabelWithChan invokes the oceanbasepro.CreateLabel API asynchronously
func (client *Client) CreateLabelWithChan(request *CreateLabelRequest) (<-chan *CreateLabelResponse, <-chan error) {
	responseChan := make(chan *CreateLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLabelWithCallback invokes the oceanbasepro.CreateLabel API asynchronously
func (client *Client) CreateLabelWithCallback(request *CreateLabelRequest, callback func(response *CreateLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLabelResponse
		var err error
		defer close(result)
		response, err = client.CreateLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLabelRequest is the request struct for api CreateLabel
type CreateLabelRequest struct {
	*requests.RpcRequest
	Name string `position:"Body" name:"Name"`
}

// CreateLabelResponse is the response struct for api CreateLabel
type CreateLabelResponse struct {
	*responses.BaseResponse
}

// CreateCreateLabelRequest creates a request to invoke CreateLabel API
func CreateCreateLabelRequest() (request *CreateLabelRequest) {
	request = &CreateLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateLabel", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLabelResponse creates a response to parse from CreateLabel response
func CreateCreateLabelResponse() (response *CreateLabelResponse) {
	response = &CreateLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
